/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.NamedThreadFactory;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NoteEventAsyncListener
implements NoteEventListener,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoteEventAsyncListener.class);
    private final ThreadPoolExecutor executor;
    private final String name;

    protected NoteEventAsyncListener(String name) {
        this.name = name;
        this.executor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(name));
    }

    public abstract void handleNoteCreateEvent(NoteCreateEvent var1);

    public abstract void handleNoteRemoveEvent(NoteRemoveEvent var1);

    public abstract void handleNoteUpdateEvent(NoteUpdateEvent var1);

    public abstract void handleParagraphCreateEvent(ParagraphCreateEvent var1);

    public abstract void handleParagraphRemoveEvent(ParagraphRemoveEvent var1);

    public abstract void handleParagraphUpdateEvent(ParagraphUpdateEvent var1);

    @Override
    public void close() {
        ExecutorUtil.softShutdown((String)this.name, (ExecutorService)this.executor, (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public void onNoteCreate(Note note, AuthenticationInfo subject) {
        this.executor.execute(new EventHandling(new NoteCreateEvent(note.getId())));
    }

    @Override
    public void onNoteRemove(Note note, AuthenticationInfo subject) {
        this.executor.execute(new EventHandling(new NoteRemoveEvent(note.getId())));
    }

    @Override
    public void onNoteUpdate(Note note, AuthenticationInfo subject) {
        this.executor.execute(new EventHandling(new NoteUpdateEvent(note.getId())));
    }

    @Override
    public void onParagraphCreate(Paragraph p) {
        this.executor.execute(new EventHandling(new ParagraphCreateEvent(p.getNote().getId(), p.getId())));
    }

    @Override
    public void onParagraphRemove(Paragraph p) {
        this.executor.execute(new EventHandling(new ParagraphRemoveEvent(p.getNote().getId(), p.getId())));
    }

    @Override
    public void onParagraphUpdate(Paragraph p) {
        this.executor.execute(new EventHandling(new ParagraphUpdateEvent(p.getNote().getId(), p.getId())));
    }

    @Override
    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        this.executor.execute(new EventHandling(new ParagraphStatusChangeEvent(p.getNote().getId(), p.getId())));
    }

    public boolean isEventQueueEmpty() {
        return this.executor.getQueue().isEmpty();
    }

    public static class ParagraphStatusChangeEvent
    implements NoteEvent {
        private final String nodeId;
        private final String paragraphId;

        public ParagraphStatusChangeEvent(String nodeId, String paragraphId) {
            this.nodeId = nodeId;
            this.paragraphId = paragraphId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getParagraphId() {
            return this.paragraphId;
        }
    }

    public static class ParagraphRemoveEvent
    implements NoteEvent {
        private final String nodeId;
        private final String paragraphId;

        public ParagraphRemoveEvent(String nodeId, String paragraphId) {
            this.nodeId = nodeId;
            this.paragraphId = paragraphId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getParagraphId() {
            return this.paragraphId;
        }
    }

    public static class ParagraphUpdateEvent
    implements NoteEvent {
        private final String nodeId;
        private final String paragraphId;

        public ParagraphUpdateEvent(String nodeId, String paragraphId) {
            this.nodeId = nodeId;
            this.paragraphId = paragraphId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getParagraphId() {
            return this.paragraphId;
        }
    }

    public static class ParagraphCreateEvent
    implements NoteEvent {
        private final String nodeId;
        private final String paragraphId;

        public ParagraphCreateEvent(String nodeId, String paragraphId) {
            this.nodeId = nodeId;
            this.paragraphId = paragraphId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getParagraphId() {
            return this.paragraphId;
        }
    }

    public static class NoteRemoveEvent
    implements NoteEvent {
        private final String noteId;

        public NoteRemoveEvent(String noteId) {
            this.noteId = noteId;
        }

        public String getNoteId() {
            return this.noteId;
        }
    }

    public static class NoteUpdateEvent
    implements NoteEvent {
        private final String noteId;

        public NoteUpdateEvent(String noteId) {
            this.noteId = noteId;
        }

        public String getNoteId() {
            return this.noteId;
        }
    }

    public static class NoteCreateEvent
    implements NoteEvent {
        private final String noteId;

        public NoteCreateEvent(String noteId) {
            this.noteId = noteId;
        }

        public String getNoteId() {
            return this.noteId;
        }
    }

    static interface NoteEvent {
    }

    class EventHandling
    implements Runnable {
        private final NoteEvent event;

        public EventHandling(NoteEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            block8: {
                try {
                    if (this.event instanceof NoteCreateEvent) {
                        NoteEventAsyncListener.this.handleNoteCreateEvent((NoteCreateEvent)this.event);
                        break block8;
                    }
                    if (this.event instanceof NoteRemoveEvent) {
                        NoteEventAsyncListener.this.handleNoteRemoveEvent((NoteRemoveEvent)this.event);
                        break block8;
                    }
                    if (this.event instanceof NoteUpdateEvent) {
                        NoteEventAsyncListener.this.handleNoteUpdateEvent((NoteUpdateEvent)this.event);
                        break block8;
                    }
                    if (this.event instanceof ParagraphCreateEvent) {
                        NoteEventAsyncListener.this.handleParagraphCreateEvent((ParagraphCreateEvent)this.event);
                        break block8;
                    }
                    if (this.event instanceof ParagraphRemoveEvent) {
                        NoteEventAsyncListener.this.handleParagraphRemoveEvent((ParagraphRemoveEvent)this.event);
                        break block8;
                    }
                    if (this.event instanceof ParagraphUpdateEvent) {
                        NoteEventAsyncListener.this.handleParagraphUpdateEvent((ParagraphUpdateEvent)this.event);
                        break block8;
                    }
                    throw new RuntimeException("Unknown event: " + this.event.getClass().getSimpleName());
                }
                catch (Exception e) {
                    LOGGER.error("Fail to handle NoteEvent", (Throwable)e);
                }
            }
        }
    }
}

