/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.sql;

import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.JobManager;
import org.apache.zeppelin.flink.sql.AbstractStreamSqlJob;
import org.apache.zeppelin.flink.sql.UpdateStreamSqlJob;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.tabledata.TableDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendStreamSqlJob
extends AbstractStreamSqlJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateStreamSqlJob.class);
    private List<Row> materializedTable = new ArrayList<Row>();
    private long tsWindowThreshold;

    public AppendStreamSqlJob(StreamExecutionEnvironment senv, TableEnvironment stEnv, JobManager jobManager, InterpreterContext context, int defaultParallelism, FlinkShims flinkShims) {
        super(senv, stEnv, jobManager, context, defaultParallelism, flinkShims);
        this.tsWindowThreshold = Long.parseLong(context.getLocalProperties().getOrDefault("threshold", "3600000"));
    }

    @Override
    protected String getType() {
        return "ts";
    }

    @Override
    protected void checkTableSchema(TableSchema schema) throws Exception {
    }

    @Override
    protected void processInsert(Row row) {
        LOGGER.debug("processInsert: {}", (Object)row.toString());
        this.materializedTable.add(row);
    }

    @Override
    protected void processDelete(Row row) {
        throw new RuntimeException("Delete operation is not expected");
    }

    @Override
    protected String buildResult() {
        StringBuilder builder = new StringBuilder();
        builder.append("%table\n");
        for (int i = 0; i < this.schema.getFieldCount(); ++i) {
            String field = this.schema.getFieldNames()[i];
            builder.append(field);
            if (i == this.schema.getFieldCount() - 1) continue;
            builder.append("\t");
        }
        builder.append("\n");
        this.materializedTable.sort((r1, r2) -> {
            String f1 = TableDataUtils.normalizeColumn((String)StringUtils.arrayAwareToString((Object)r1.getField(0)));
            String f2 = TableDataUtils.normalizeColumn((String)StringUtils.arrayAwareToString((Object)r2.getField(0)));
            return f1.compareTo(f2);
        });
        if (!this.materializedTable.isEmpty()) {
            if (this.flinkShims.getFlinkVersion().isAfterFlink114()) {
                LocalDateTime ldt = (LocalDateTime)this.materializedTable.get(this.materializedTable.size() - 1).getField(0);
                long maxTimestamp = Timestamp.valueOf(ldt).getTime();
                this.materializedTable = this.materializedTable.stream().filter(row -> Timestamp.valueOf((LocalDateTime)row.getField(0)).getTime() > maxTimestamp - this.tsWindowThreshold).collect(Collectors.toList());
                builder.append(this.tableToString(this.materializedTable));
            } else {
                long maxTimestamp = ((Timestamp)this.materializedTable.get(this.materializedTable.size() - 1).getField(0)).getTime();
                this.materializedTable = this.materializedTable.stream().filter(row -> ((Timestamp)row.getField(0)).getTime() > maxTimestamp - this.tsWindowThreshold).collect(Collectors.toList());
                builder.append(this.tableToString(this.materializedTable));
            }
        }
        builder.append("\n%text ");
        return builder.toString();
    }

    @Override
    protected void refresh(InterpreterContext context) {
        context.out().clear(false);
        try {
            String result = this.buildResult();
            context.out.write(result);
            context.out.flush();
            LOGGER.debug("Refresh with data: {}", (Object)result);
        }
        catch (IOException e) {
            LOGGER.error("Fail to refresh data", e);
        }
    }
}

