/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashSet;
import javax.ws.rs.WebApplicationException;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.SimpleServiceCallback;
import org.apache.zeppelin.user.AuthenticationInfo;

public class AbstractRestApi {
    protected AuthenticationService authenticationService;
    protected static final Gson GSON = new Gson();

    protected AbstractRestApi(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected ServiceContext getServiceContext() {
        AuthenticationInfo authInfo = new AuthenticationInfo(this.authenticationService.getPrincipal());
        authInfo.setRoles(this.authenticationService.getAssociatedRoles());
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        return new ServiceContext(authInfo, userAndRoles);
    }

    public static class RestServiceCallback<T>
    extends SimpleServiceCallback<T> {
        @Override
        public void onFailure(Exception ex, ServiceContext context) throws IOException {
            super.onFailure(ex, context);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new IOException(ex);
        }
    }
}

