/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.DashboardColor;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.DecimalPlaces;
import com.influxdb.client.domain.RenamableField;
import com.influxdb.client.domain.ViewProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TableViewProperties
extends ViewProperties {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.TABLE;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @SerializedName(value="queries")
    private List<DashboardQuery> queries = new ArrayList<DashboardQuery>();
    public static final String SERIALIZED_NAME_COLORS = "colors";
    @SerializedName(value="colors")
    private List<DashboardColor> colors = new ArrayList<DashboardColor>();
    public static final String SERIALIZED_NAME_SHAPE = "shape";
    @SerializedName(value="shape")
    private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
    @SerializedName(value="showNoteWhenEmpty")
    private Boolean showNoteWhenEmpty;
    public static final String SERIALIZED_NAME_TABLE_OPTIONS = "tableOptions";
    @SerializedName(value="tableOptions")
    private Object tableOptions = null;
    public static final String SERIALIZED_NAME_FIELD_OPTIONS = "fieldOptions";
    @SerializedName(value="fieldOptions")
    private List<RenamableField> fieldOptions = new ArrayList<RenamableField>();
    public static final String SERIALIZED_NAME_TIME_FORMAT = "timeFormat";
    @SerializedName(value="timeFormat")
    private String timeFormat;
    public static final String SERIALIZED_NAME_DECIMAL_PLACES = "decimalPlaces";
    @SerializedName(value="decimalPlaces")
    private DecimalPlaces decimalPlaces = null;

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public TableViewProperties queries(List<DashboardQuery> queries) {
        this.queries = queries;
        return this;
    }

    public TableViewProperties addQueriesItem(DashboardQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<DashboardQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DashboardQuery> queries) {
        this.queries = queries;
    }

    public TableViewProperties colors(List<DashboardColor> colors) {
        this.colors = colors;
        return this;
    }

    public TableViewProperties addColorsItem(DashboardColor colorsItem) {
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Colors define color encoding of data into a visualization")
    public List<DashboardColor> getColors() {
        return this.colors;
    }

    public void setColors(List<DashboardColor> colors) {
        this.colors = colors;
    }

    @ApiModelProperty(required=true, value="")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public TableViewProperties note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public TableViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, will display note when empty")
    public Boolean getShowNoteWhenEmpty() {
        return this.showNoteWhenEmpty;
    }

    public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
    }

    public TableViewProperties tableOptions(Object tableOptions) {
        this.tableOptions = tableOptions;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Object getTableOptions() {
        return this.tableOptions;
    }

    public void setTableOptions(Object tableOptions) {
        this.tableOptions = tableOptions;
    }

    public TableViewProperties fieldOptions(List<RenamableField> fieldOptions) {
        this.fieldOptions = fieldOptions;
        return this;
    }

    public TableViewProperties addFieldOptionsItem(RenamableField fieldOptionsItem) {
        this.fieldOptions.add(fieldOptionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="fieldOptions represent the fields retrieved by the query with customization options")
    public List<RenamableField> getFieldOptions() {
        return this.fieldOptions;
    }

    public void setFieldOptions(List<RenamableField> fieldOptions) {
        this.fieldOptions = fieldOptions;
    }

    public TableViewProperties timeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="timeFormat describes the display format for time values according to moment.js date formatting")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public TableViewProperties decimalPlaces(DecimalPlaces decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DecimalPlaces getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(DecimalPlaces decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableViewProperties tableViewProperties = (TableViewProperties)o;
        return Objects.equals((Object)this.type, (Object)tableViewProperties.type) && Objects.equals(this.queries, tableViewProperties.queries) && Objects.equals(this.colors, tableViewProperties.colors) && Objects.equals((Object)this.shape, (Object)tableViewProperties.shape) && Objects.equals(this.note, tableViewProperties.note) && Objects.equals(this.showNoteWhenEmpty, tableViewProperties.showNoteWhenEmpty) && Objects.equals(this.tableOptions, tableViewProperties.tableOptions) && Objects.equals(this.fieldOptions, tableViewProperties.fieldOptions) && Objects.equals(this.timeFormat, tableViewProperties.timeFormat) && Objects.equals(this.decimalPlaces, tableViewProperties.decimalPlaces) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.queries, this.colors, this.shape, this.note, this.showNoteWhenEmpty, this.tableOptions, this.fieldOptions, this.timeFormat, this.decimalPlaces, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    showNoteWhenEmpty: ").append(this.toIndentedString(this.showNoteWhenEmpty)).append("\n");
        sb.append("    tableOptions: ").append(this.toIndentedString(this.tableOptions)).append("\n");
        sb.append("    fieldOptions: ").append(this.toIndentedString(this.fieldOptions)).append("\n");
        sb.append("    timeFormat: ").append(this.toIndentedString(this.timeFormat)).append("\n");
        sb.append("    decimalPlaces: ").append(this.toIndentedString(this.decimalPlaces)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        CHRONOGRAF_V2("chronograf-v2");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TABLE("table");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

