/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import java.io.IOException;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.helium.ApplicationContext;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.resource.ResourceSet;

@Experimental
public abstract class Application {
    private final ApplicationContext context;

    protected Application(ApplicationContext context) {
        this.context = context;
    }

    public ApplicationContext context() {
        return this.context;
    }

    @Experimental
    public abstract void run(ResourceSet var1) throws ApplicationException, IOException;

    @Experimental
    public abstract void unload() throws ApplicationException;

    @Experimental
    public void print(String string) throws IOException {
        this.context.out.write(string);
    }

    @Experimental
    public void println(String string) throws IOException {
        this.print(string + "\n");
    }

    @Experimental
    public void printResource(String resourceName) throws IOException {
        this.context.out.writeResource(resourceName);
    }

    @Experimental
    public void printResourceAsJavascript(String resourceName) throws IOException {
        this.beginJavascript();
        this.context.out.writeResource(resourceName);
        this.endJavascript();
    }

    @Experimental
    public void printStringAsJavascript(String js) throws IOException {
        this.beginJavascript();
        this.context.out.write(js);
        this.endJavascript();
    }

    private void beginJavascript() throws IOException {
        StringBuilder js = new StringBuilder();
        js.append("\n<script id=\"app_js_" + js.hashCode() + "\">\n");
        js.append("(function() {\n");
        js.append("let $z = {\n");
        js.append("id : \"" + this.context.getApplicationInstanceId() + "\",\n");
        js.append("scope : angular.element(\"#app_js_" + js.hashCode() + "\").scope()\n");
        js.append("};\n");
        js.append("$z.result = ($z.scope._devmodeResult) ? $z.scope._devmodeResult : $z.scope.$parent.paragraph.result;\n");
        this.context.out.write(js.toString());
    }

    private void endJavascript() throws IOException {
        StringBuilder js = new StringBuilder();
        js.append("\n})();\n");
        js.append("</script>\n");
        this.context.out.write(js.toString());
    }
}

