/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.eclipse.aether.internal.impl.slf4j;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.locator.Service;
import shaded.org.apache.zeppelin.org.eclipse.aether.spi.locator.ServiceLocator;

@Named(value="slf4j")
public class Slf4jLoggerFactory
implements shaded.org.apache.zeppelin.org.eclipse.aether.spi.log.LoggerFactory,
Service {
    private static final boolean AVAILABLE;
    private ILoggerFactory factory;

    public static boolean isSlf4jAvailable() {
        return AVAILABLE;
    }

    public Slf4jLoggerFactory() {
    }

    @Inject
    Slf4jLoggerFactory(@Nullable ILoggerFactory factory) {
        this.setLoggerFactory(factory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(ILoggerFactory.class));
    }

    public Slf4jLoggerFactory setLoggerFactory(ILoggerFactory factory) {
        this.factory = factory;
        return this;
    }

    @Override
    public shaded.org.apache.zeppelin.org.eclipse.aether.spi.log.Logger getLogger(String name) {
        Logger logger = this.getFactory().getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLoggerEx((LocationAwareLogger)logger);
        }
        return new Slf4jLogger(logger);
    }

    private ILoggerFactory getFactory() {
        if (this.factory == null) {
            this.factory = LoggerFactory.getILoggerFactory();
        }
        return this.factory;
    }

    static {
        boolean available;
        try {
            Slf4jLoggerFactory.class.getClassLoader().loadClass("shaded/org/apache/zeppelin/org.slf4j.ILoggerFactory");
            available = true;
        }
        catch (Exception | LinkageError e) {
            available = false;
        }
        AVAILABLE = available;
    }

    private static final class Slf4jLoggerEx
    implements shaded.org.apache.zeppelin.org.eclipse.aether.spi.log.Logger {
        private static final String FQCN = Slf4jLoggerEx.class.getName();
        private final LocationAwareLogger logger;

        Slf4jLoggerEx(LocationAwareLogger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.log(null, FQCN, 10, msg, null, null);
        }

        @Override
        public void debug(String msg, Throwable error) {
            this.logger.log(null, FQCN, 10, msg, null, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.log(null, FQCN, 30, msg, null, null);
        }

        @Override
        public void warn(String msg, Throwable error) {
            this.logger.log(null, FQCN, 30, msg, null, error);
        }
    }

    private static final class Slf4jLogger
    implements shaded.org.apache.zeppelin.org.eclipse.aether.spi.log.Logger {
        private final Logger logger;

        Slf4jLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String msg, Throwable error) {
            this.logger.debug(msg, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable error) {
            this.logger.warn(msg, error);
        }
    }
}

