/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import shaded.org.apache.zeppelin.com.google.inject.Binder;
import shaded.org.apache.zeppelin.com.google.inject.Module;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;
import shaded.org.apache.zeppelin.com.google.inject.matcher.AbstractMatcher;
import shaded.org.apache.zeppelin.com.google.inject.matcher.Matcher;
import shaded.org.apache.zeppelin.com.google.inject.spi.TypeConverter;

public final class PlexusDateTypeConverter
extends AbstractMatcher<TypeLiteral<?>>
implements TypeConverter,
Module {
    private static final DateFormat[] PLEXUS_DATE_FORMATS;
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";

    static {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S a", Locale.US), new SimpleDateFormat("yyyy-MM-dd hh:mm:ssa", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US)};
        int n = PLEXUS_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat f = dateFormatArray[n2];
            f.setLenient(false);
            ++n2;
        }
    }

    public void configure(Binder binder) {
        binder.convertToTypes((Matcher)this, (TypeConverter)this);
    }

    public boolean matches(TypeLiteral<?> type) {
        return Date.class == type.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, TypeLiteral<?> toType) {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS;
        int n = PLEXUS_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat f = dateFormatArray[n2];
            try {
                DateFormat dateFormat = f;
                synchronized (dateFormat) {
                    return f.parse(value);
                }
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, Date.class));
    }
}

