/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.scheduler.AbstractScheduler;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.NamedThreadFactory;
import org.apache.zeppelin.util.ExecutorUtil;

public class ParallelScheduler
extends AbstractScheduler {
    private ExecutorService executor;

    ParallelScheduler(String name, int maxConcurrency) {
        super(name);
        this.executor = Executors.newFixedThreadPool(maxConcurrency, new NamedThreadFactory("ParallelScheduler-Worker"));
    }

    @Override
    public void runJobInScheduler(Job<?> runningJob) {
        this.executor.execute(() -> this.runJob(runningJob));
    }

    @Override
    public void stop() {
        this.stop(2, TimeUnit.MINUTES);
    }

    @Override
    public void stop(int stopTimeoutVal, TimeUnit stopTimeoutUnit) {
        super.stop();
        ExecutorUtil.softShutdown(this.name, this.executor, stopTimeoutVal, stopTimeoutUnit);
    }
}

