/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.tabledata.TableDataUtils;

public class SingleRowInterpreterResult {
    private String template;
    private List<Object> values;
    private InterpreterContext context;

    public SingleRowInterpreterResult(List<Object> values, String template, InterpreterContext context) {
        this.values = values;
        this.template = template;
        this.context = context;
    }

    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("%html ");
        String outputText = this.template;
        for (int i = 0; i < this.values.size(); ++i) {
            outputText = outputText.replace("{" + i + "}", this.values.get(i).toString());
        }
        builder.append(outputText);
        return builder.toString();
    }

    public String toAngular() {
        StringBuilder builder = new StringBuilder();
        builder.append("%angular ");
        String outputText = this.template;
        for (int i = 0; i < this.values.size(); ++i) {
            outputText = outputText.replace("{" + i + "}", "{{value_" + i + "}}");
        }
        builder.append(outputText);
        return builder.toString();
    }

    public void pushAngularObjects() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.context.getAngularObjectRegistry().add("value_" + i, TableDataUtils.normalizeColumn(this.values.get(i)), this.context.getNoteId(), this.context.getParagraphId());
        }
    }
}

