/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dvsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.dvsl.DVSLContext;
import org.apache.dvsl.TemplateHandler;
import org.apache.dvsl.Transformer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.log.LogChuteSystem;
import org.apache.velocity.runtime.log.LogSystem;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class DVSL {
    private static String TOOL_PROP_PREFIX = "toolbox.tool.";
    private static String STRING_PROP_PREFIX = "toolbox.string.";
    private static String INTEGER_PROP_PREFIX = "toolbox.integer.";
    private static String TOOLBOX_NAME = "toolbox.contextname.";
    private VelocityEngine ve = null;
    private Document currentDocument = null;
    private Writer currentWriter = null;
    private Context toolContext;
    private Context userContext;
    private Context styleContext;
    private DVSLContext baseContext = new DVSLContext();
    private Transformer transformer;
    private ClassLoader classLoader;
    private boolean ready = false;
    private Map velConfig = null;
    private File logFile;
    private LogChute logger;
    private Map appVals = new HashMap();
    private TemplateHandler templateHandler = new TemplateHandler();
    boolean validate = false;

    public DVSL() {
        this.classLoader = DVSL.class.getClassLoader();
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
        if (this.velConfig == null) {
            this.velConfig = new HashMap();
        }
        this.velConfig.put("runtime.log", logFile.getAbsolutePath());
    }

    public void setLogSystem(LogSystem logger) {
        this.logger = new LogAdapter(logger);
        if (this.velConfig == null) {
            this.velConfig = new HashMap();
        }
        this.velConfig.put("runtime.log.logsystem", logger);
    }

    public void setLogChute(LogChute logger) {
        this.logger = logger;
        if (this.velConfig == null) {
            this.velConfig = new HashMap();
        }
        this.velConfig.put("runtime.log.logsystem", logger);
    }

    public void setVelocityConfig(Map map) {
        if (this.velConfig != null) {
            map.putAll(this.velConfig);
        }
        this.velConfig = map;
    }

    public void setUserContext(Context ctx) {
        this.ready = false;
        this.userContext = ctx;
    }

    public void setValidatingParser(boolean validate) {
        this.validate = validate;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public void setToolbox(Properties p) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.ready = false;
        HashMap<String, Object> toolbox = new HashMap<String, Object>();
        String toolboxname = "toolbox";
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String toolname;
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            if (key.startsWith(TOOL_PROP_PREFIX)) {
                toolname = key.substring(TOOL_PROP_PREFIX.length());
                Object o = Class.forName(value, true, this.classLoader).newInstance();
                toolbox.put(toolname, o);
                continue;
            }
            if (key.startsWith(INTEGER_PROP_PREFIX)) {
                toolname = key.substring(INTEGER_PROP_PREFIX.length());
                int i = 0;
                try {
                    i = Integer.parseInt(value);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                toolbox.put(toolname, new Integer(i));
                continue;
            }
            if (key.startsWith(STRING_PROP_PREFIX)) {
                toolname = key.substring(STRING_PROP_PREFIX.length());
                toolbox.put(toolname, value);
                continue;
            }
            if (!key.startsWith(TOOLBOX_NAME)) continue;
            toolboxname = value;
        }
        this.toolContext = new VelocityContext();
        this.toolContext.put(toolboxname, toolbox);
    }

    public void setStylesheet(String stylesheet) throws Exception {
        this.setStylesheet(new File(stylesheet), null);
    }

    public void setStylesheet(File stylesheet) throws Exception {
        this.setStylesheet(stylesheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStylesheet(File stylesheet, String stylesheetEncoding) throws Exception {
        Reader fr = null;
        try {
            fr = stylesheetEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(stylesheet), stylesheetEncoding) : new FileReader(stylesheet);
            this.setStylesheet(fr);
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
    }

    public void setStylesheet(Reader styleReader) throws Exception {
        this.ready = false;
        this.ve = new VelocityEngine();
        if (this.velConfig != null) {
            this.configureVelocityEngine(this.ve, this.velConfig);
        }
        this.ve.setProperty("userdirective", (Object)"org.apache.dvsl.directive.MatchDirective");
        this.ve.init();
        this.ve.setApplicationAttribute((Object)"org.apache.dvsl.TemplateHandler", (Object)this.templateHandler);
        StringWriter junkWriter = new StringWriter();
        this.styleContext = new VelocityContext();
        this.ve.evaluate(this.styleContext, (Writer)junkWriter, "DVSL:stylesheet", styleReader);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/dvsl/resource/defaultroot.dvsl");
        if (is == null) {
            System.out.println("DEFAULT TRANSFORM RULES NOT FOUND ");
        } else {
            this.ve.evaluate((Context)new VelocityContext(), (Writer)junkWriter, "defaultroot.dvsl", (Reader)new InputStreamReader(is));
            is.close();
        }
        this.transformer = new Transformer(this.ve, this.templateHandler, (Context)this.baseContext, this.appVals, this.validate);
    }

    private void configureVelocityEngine(VelocityEngine ve, Map map) {
        if (ve == null || map == null) {
            return;
        }
        Object val = map.get("velocimacro.library");
        if (val instanceof String) {
            ve.setProperty("velocimacro.library", (Object)((String)val));
        }
        if ((val = map.get("file.resource.loader.path")) instanceof String) {
            ve.setProperty("file.resource.loader.path", (Object)((String)val));
        }
        if ((val = map.get("runtime.log")) instanceof String) {
            ve.setProperty("runtime.log", val);
        }
        if ((val = map.get("runtime.log.logsystem")) != null) {
            ve.setProperty("runtime.log.logsystem", val);
        }
        if ((val = map.get("runtime.log.logsystem.class")) instanceof String) {
            ve.setProperty("runtime.log.logsystem.class", val);
        }
    }

    protected void makeReady() {
        this.baseContext.clearContexts();
        this.baseContext.addContext(this.userContext);
        this.baseContext.addContext(this.toolContext);
        this.baseContext.setStyleContext(this.styleContext);
        this.ready = true;
    }

    protected long xform(Reader reader, Writer writer) throws Exception {
        if (!this.ready) {
            this.makeReady();
        }
        return this.transformer.transform(reader, writer);
    }

    protected long xform(Document dom4jdoc, Writer writer) throws Exception {
        if (!this.ready) {
            this.makeReady();
        }
        return this.transformer.transform(dom4jdoc, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transform(File f, Writer writer) throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            long l = this.transform(is, writer);
            return l;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public long transform(Reader reader, Writer writer) throws Exception {
        return this.xform(reader, writer);
    }

    public long transform(InputStream is, Writer writer) throws Exception {
        SAXReader reader = new SAXReader();
        return this.xform(reader.read(is), writer);
    }

    public long transform(Document dom4jdoc, Writer writer) throws Exception {
        return this.xform(dom4jdoc, writer);
    }

    public long transform(String infile, Writer writer) throws Exception {
        return this.transform(new File(infile), writer);
    }

    public Object getAppValue(Object key) {
        return this.appVals.get(key);
    }

    public Object putAppValue(Object key, Object value) {
        return this.appVals.put(key, value);
    }

    public static void main(String[] args) throws Exception {
        DVSL dvsl = new DVSL();
        InputStreamReader in = new InputStreamReader(System.in);
        String infile = null;
        String style = null;
        String outfile = null;
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        String toolfile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-IN")) {
                infile = args[++i];
                continue;
            }
            if (args[i].equals("-OUT")) {
                outfile = args[++i];
                continue;
            }
            if (args[i].equals("-STYLE")) {
                style = args[++i];
                continue;
            }
            if (!args[i].equals("-TOOL")) continue;
            toolfile = args[++i];
        }
        if (style == null) {
            System.out.println("usage :need to specify a stylesheet. ");
            System.out.println("java -jar dvsl.jar -STYLE stylesheeet [-IN infile] [-OUT outfile] [-TOOL toolboxname]");
            return;
        }
        if (style != null) {
            dvsl.setStylesheet(style);
        }
        if (toolfile != null) {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(toolfile);
            p.load(fis);
            dvsl.setToolbox(p);
        }
        if (infile != null) {
            in = new FileReader(infile);
        }
        if (outfile != null) {
            out = new FileWriter(outfile);
        }
        long time = dvsl.transform(in, (Writer)out);
        ((Writer)out).flush();
    }

    protected static class LogAdapter
    extends LogChuteSystem {
        protected LogAdapter(LogSystem logSystem) {
            super(logSystem);
        }
    }
}

