/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.queries;

import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.AggregateQuery;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.QueryService;
import org.apache.unomi.api.utils.ParserHelper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.IpRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.NumericRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImpl
implements QueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QueryServiceImpl.class.getName());
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void postConstruct() {
        LOGGER.info("Query service initialized.");
    }

    public void preDestroy() {
        LOGGER.info("Query service shutdown.");
    }

    public Map<String, Long> getAggregate(String itemType, String property) {
        return this.persistenceService.aggregateWithOptimizedQuery(null, (BaseAggregate)new TermsAggregate(property), itemType);
    }

    @Deprecated
    public Map<String, Long> getAggregate(String itemType, String property, AggregateQuery query) {
        return this.getAggregate(itemType, property, query, false);
    }

    public Map<String, Long> getAggregateWithOptimizedQuery(String itemType, String property, AggregateQuery query) {
        return this.getAggregate(itemType, property, query, true);
    }

    public Map<String, Double> getMetric(String type, String property, String slashConcatenatedMetrics, Condition condition) {
        if (condition.getConditionType() == null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)condition, (String)("metric " + type + " on property " + property));
        }
        return this.persistenceService.getSingleValuesMetrics(condition, slashConcatenatedMetrics.split("/"), property, type);
    }

    public long getQueryCount(String itemType, Condition condition) {
        if (condition.getConditionType() == null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)condition, (String)("query count on " + itemType));
        }
        return this.persistenceService.queryCount(condition, itemType);
    }

    private Map<String, Long> getAggregate(String itemType, String property, AggregateQuery query, boolean optimizedQuery) {
        if (query != null) {
            String aggregateType;
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)query.getCondition(), (String)("aggregate on property " + property + " for type " + itemType));
            TermsAggregate baseAggregate = null;
            if (query.getAggregate() != null && (aggregateType = query.getAggregate().getType()) != null) {
                if (aggregateType.equals("date")) {
                    String interval = (String)query.getAggregate().getParameters().get("interval");
                    String format = (String)query.getAggregate().getParameters().get("format");
                    baseAggregate = new DateAggregate(property, interval, format);
                } else if (aggregateType.equals("dateRange") && query.getAggregate().getDateRanges() != null && !query.getAggregate().getDateRanges().isEmpty()) {
                    String format = (String)query.getAggregate().getParameters().get("format");
                    baseAggregate = new DateRangeAggregate(query.getAggregate().getProperty(), format, query.getAggregate().getDateRanges());
                } else if (aggregateType.equals("numericRange") && query.getAggregate().getNumericRanges() != null && !query.getAggregate().getNumericRanges().isEmpty()) {
                    baseAggregate = new NumericRangeAggregate(query.getAggregate().getProperty(), query.getAggregate().getNumericRanges());
                } else if (aggregateType.equals("ipRange") && query.getAggregate().ipRanges() != null && !query.getAggregate().ipRanges().isEmpty()) {
                    baseAggregate = new IpRangeAggregate(query.getAggregate().getProperty(), query.getAggregate().ipRanges());
                }
            }
            if (baseAggregate == null) {
                baseAggregate = new TermsAggregate(property);
            }
            if (optimizedQuery) {
                return this.persistenceService.aggregateWithOptimizedQuery(query.getCondition(), (BaseAggregate)baseAggregate, itemType);
            }
            return this.persistenceService.aggregateQuery(query.getCondition(), (BaseAggregate)baseAggregate, itemType);
        }
        return this.getAggregate(itemType, property);
    }
}

