/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi.interceptors;

import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.legacyapi.TagsUtils;
import io.smallrye.metrics.legacyapi.interceptors.MetricResolver;
import io.smallrye.metrics.legacyapi.interceptors.MetricsBinding;
import io.smallrye.metrics.setup.MetricsMetadata;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Gauge;

@Interceptor
@MetricsBinding
@Priority(value=1000)
public class GaugeRegistrationInterceptor {
    private MetricRegistry registry;
    private final MetricResolver resolver = new MetricResolver();

    GaugeRegistrationInterceptor() {
    }

    @AroundConstruct
    Object metrics(InvocationContext context) throws Exception {
        Class type = context.getConstructor().getDeclaringClass();
        Object target = context.proceed();
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<Method> memberInfoAdapter = new CDIMemberInfoAdapter<Method>();
        do {
            for (Method method : type.getDeclaredMethods()) {
                MetricResolver.Of<Gauge> gauge = this.resolver.gauge(beanInfoAdapter.convert(type), memberInfoAdapter.convert(method));
                if (!gauge.isPresent()) continue;
                AnnotationInfo g = gauge.metricAnnotation();
                Metadata metadata = MetricsMetadata.getMetadata(g, gauge.metricName(), g.unit(), g.description());
                this.registry = SharedMetricRegistries.getOrCreate(g.scope());
                AccessController.doPrivileged(() -> {
                    method.setAccessible(true);
                    return null;
                });
                this.registry.gauge(metadata, context.getTarget(), i -> (Number)GaugeRegistrationInterceptor.invokeMethod(method, i), TagsUtils.parseTagsAsArray(g.tags()));
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }
}

