/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class CommonAuthorityCode {
    static final char SEPARATOR = ',';
    final String localCode;
    private String complement;
    private double[] parameters;
    private int versionOfAuto;
    final boolean isNumeric;
    boolean isOGC;

    CommonAuthorityCode(String code) throws NoSuchAuthorityCodeException {
        int length;
        int s = code.indexOf(58);
        if (s >= 0) {
            int end = CharSequences.skipTrailingWhitespaces(code, 0, s);
            int start = CharSequences.skipLeadingWhitespaces(code, 0, end);
            this.isOGC = GeodeticAuthorityFactory.regionMatches("OGC", code, start, end);
            if (!this.isOGC && !GeodeticAuthorityFactory.regionMatches("CRS", code, start, end)) {
                if (code.regionMatches(true, start, "AUTO", 0, 4)) {
                    switch (end - start) {
                        case 4: {
                            this.versionOfAuto = 1;
                            break;
                        }
                        case 5: {
                            this.versionOfAuto = code.charAt(end - 1) - 48;
                        }
                    }
                }
                if (!this.isAuto(false)) {
                    throw new NoSuchAuthorityCodeException(Resources.format((short)66, CharSequences.trimWhitespaces(code, 0, s)), "OGC", code);
                }
            }
        }
        if (code.regionMatches(true, s = CharSequences.skipLeadingWhitespaces(code, s + 1, length = code.length()), "CRS", 0, "CRS".length())) {
            s = CharSequences.skipLeadingWhitespaces(code, s + "CRS".length(), length);
        }
        if (s >= length) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)29, "code"), "OGC", code);
        }
        int end = CharSequences.skipTrailingWhitespaces(code, s, length);
        int startOfParameters = code.indexOf(44, s);
        if (startOfParameters >= 0) {
            this.complement = code.substring(CharSequences.skipLeadingWhitespaces(code, startOfParameters + 1, end), end);
            end = CharSequences.skipTrailingWhitespaces(code, s, startOfParameters);
        }
        this.localCode = code.substring(s, end);
        char c = this.localCode.charAt(0);
        this.isNumeric = c >= '0' && c <= '9' || c == '-' || c == '+';
    }

    final boolean isAuto(boolean legacy) {
        return legacy ? this.versionOfAuto == 1 : this.versionOfAuto >= 1 && this.versionOfAuto <= 2;
    }

    final boolean isParameterless() {
        return this.complement == null || this.complement.isEmpty();
    }

    final double[] parameters() {
        if (this.parameters == null) {
            this.parameters = CharSequences.parseDoubles(this.complement, ',');
        }
        return this.parameters;
    }

    final String unexpectedParameters() {
        return Errors.format((short)135, this.localCode, this.complement);
    }
}

