/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.config;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.SystemPropertyUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringProperties {
    private static final Logger log = LoggerFactory.getLogger(SpringProperties.class);

    public static Properties get() {
        File oldConfig = SpringProperties.getOldConfig();
        if (oldConfig != null) {
            log.warn("In the \"conf\" directory, found the \"application.yml\" file. Please be aware that the \"application.yml\" file is now deprecated. For compatibility reasons, this \"application.yml\" file will still be used as the preference. However, the latest configuration file is now \"config.yaml\", and it is recommended to use \"config.yaml\" instead. \nNOTE: the \"application.yml\" file will be completely deprecated in version 2.2.0.");
            SystemPropertyUtils.set((String)"spring.config.location", (String)oldConfig.getAbsolutePath());
            return new Properties();
        }
        Properties userConfig = SpringProperties.getUserConfig();
        Properties springConfig = SpringProperties.getSpringConfig();
        SpringProperties.mergeConfig(userConfig, springConfig);
        SpringProperties.dataSourceConfig(userConfig, springConfig);
        springConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> SystemPropertyUtils.set((String)k.toString(), (String)v.toString())));
        return springConfig;
    }

    private static void dataSourceConfig(Properties userConfig, Properties springConfig) {
        String dialect = userConfig.getProperty("datasource.dialect", "").toString();
        if (StringUtils.isBlank((CharSequence)dialect)) {
            throw new ExceptionInInitializerError("datasource.dialect is required, please check config.yaml");
        }
        switch (dialect.toLowerCase()) {
            case "mysql": {
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                    springConfig.put("spring.datasource.driver-class-name", "com.mysql.cj.jdbc.Driver");
                    break;
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class.forName("com.mysql.jdbc.Driver");
                        springConfig.put("spring.datasource.driver-class-name", "com.mysql.jdbc.Driver");
                        break;
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ExceptionInInitializerError("The datasource.dialect is MySQL, but the classes \"com.mysql.cj.jdbc.Driver\" and \"com.mysql.jdbc.Driver\" not found. Please ensure that the MySQL Connector/J is located under $streampark/lib.\nNote: The MySQL Connector/J is not compatible with the Apache 2.0 license. You need to download it and place it into $streampark/lib.");
                    }
                }
            }
            case "postgresql": 
            case "pgsql": {
                springConfig.put("spring.datasource.driver-class-name", "org.postgresql.Driver");
                break;
            }
            case "h2": {
                String h2DataDir = userConfig.getProperty("datasource.h2-data-dir", null);
                h2DataDir = StringUtils.isBlank((CharSequence)h2DataDir) ? System.getProperty("user.home", "~") + "/streampark/h2-data/metadata" : h2DataDir + (h2DataDir.endsWith("/") ? "metadata" : "/metadata");
                springConfig.put("spring.datasource.url", String.format("jdbc:h2:file:%s;MODE=MySQL;DB_CLOSE_DELAY=-1;DATABASE_TO_LOWER=true;INIT=runscript from 'classpath:db/schema-h2.sql'", h2DataDir));
                String userName = userConfig.getProperty("spring.datasource.username", "admin");
                String password = userConfig.getProperty("spring.datasource.password", "streampark");
                springConfig.put("spring.jpa.database-platform", "org.hibernate.dialect.H2Dialect");
                springConfig.put("spring.datasource.driver-class-name", "org.h2.Driver");
                springConfig.put("spring.datasource.username", userName);
                springConfig.put("spring.datasource.password", password);
                springConfig.put("spring.sql.init.data-locations", "classpath:db/data-h2.sql");
                springConfig.put("spring.sql.init.continue-on-error", "true");
                springConfig.put("spring.sql.init.username", userName);
                springConfig.put("spring.sql.init.password", password);
                springConfig.put("spring.sql.init.mode", "always");
                springConfig.put("spring.h2.console.path", "/h2-console");
                springConfig.put("spring.h2.console.enabled", (Object)true);
                springConfig.put("spring.h2.console.settings.web-allow-others", (Object)true);
                springConfig.put("spring.h2.console.settings.trace", (Object)true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported datasource dialect: " + dialect);
            }
        }
    }

    private static void mergeConfig(Properties userConfig, Properties springConfig) {
        HashMap configMapping = Maps.newHashMap();
        configMapping.put("datasource.username", "spring.datasource.username");
        configMapping.put("datasource.password", "spring.datasource.password");
        configMapping.put("datasource.url", "spring.datasource.url");
        userConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)configMapping.get(k);
            if (key != null) {
                springConfig.put(key, v);
            } else {
                springConfig.put(k, v);
            }
        }));
    }

    private static Properties getUserConfig() {
        String appHome = WebUtils.getAppHome();
        if (StringUtils.isBlank((CharSequence)appHome)) {
            throw new ExceptionInInitializerError(String.format("[StreamPark] The system initialization check has failed. If you started locally for development and debugging, please ensure the -D%s parameter is clearly specified, more detail: https://streampark.apache.org/docs/user-guide/deployment", ConfigConst.KEY_APP_HOME()));
        }
        Properties properties = new Properties();
        File file = new File(appHome, "conf/config.yaml");
        if (file.exists() && file.isFile()) {
            HashMap config = PropertiesUtils.fromYamlFileAsJava((String)file.getAbsolutePath());
            properties.putAll((Map<?, ?>)config);
            return properties;
        }
        throw new ExceptionInInitializerError(file.getAbsolutePath() + " not found, please check.");
    }

    private static Properties getSpringConfig() {
        Properties config = new Properties();
        config.put("spring.application.name", "Apache StreamPark");
        config.put("spring.main.banner-mode", "false");
        config.put("spring.devtools.restart.enabled", "false");
        config.put("spring.aop.proxy-target-class", "true");
        config.put("spring.messages.encoding", "utf-8");
        config.put("spring.main.allow-circular-references", "true");
        config.put("spring.mvc.converters.preferred-json-mapper", "jackson");
        config.put("spring.jackson.date-format", "yyyy-MM-dd HH:mm:ss");
        config.put("spring.jackson.time-zone", "GMT+8");
        config.put("spring.jackson.deserialization.fail-on-unknown-properties", "false");
        config.put("spring.servlet.multipart.enabled", "true");
        config.put("spring.servlet.multipart.max-file-size", "-1");
        config.put("spring.servlet.multipart.max-request-size", "-1");
        config.put("springdoc.api-docs.enabled", "true");
        config.put("management.endpoints.enabled-by-default", "false");
        return config;
    }

    private static File getOldConfig() {
        String appHome = WebUtils.getAppHome();
        if (appHome == null) {
            return null;
        }
        File file = new File(appHome + "/conf/application.yml");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

