/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyMemoryMetrics;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;

public class TransportServer
implements Closeable {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(TransportServer.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final RpcHandler appRpcHandler;
    private final List<TransportServerBootstrap> bootstraps;
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private int port = -1;
    private final PooledByteBufAllocator pooledAllocator;
    private NettyMemoryMetrics metrics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportServer(TransportContext context, String hostToBind, int portToBind, RpcHandler appRpcHandler, List<TransportServerBootstrap> bootstraps) {
        this.context = context;
        this.conf = context.getConf();
        this.appRpcHandler = appRpcHandler;
        this.pooledAllocator = this.conf.sharedByteBufAllocators() ? NettyUtils.getSharedPooledByteBufAllocator(this.conf.preferDirectBufsForSharedByteBufAllocators(), true) : NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), true, this.conf.serverThreads());
        this.bootstraps = new ArrayList<TransportServerBootstrap>((Collection)Objects.requireNonNull(bootstraps));
        boolean shouldClose = true;
        try {
            this.init(hostToBind, portToBind);
            shouldClose = false;
        }
        finally {
            if (shouldClose) {
                JavaUtils.closeQuietly((Closeable)this);
            }
        }
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Server not initialized");
        }
        return this.port;
    }

    private void init(String hostToBind, int portToBind) {
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        EventLoopGroup bossGroup = NettyUtils.createEventLoop(ioMode, 1, this.conf.getModuleName() + "-boss");
        EventLoopGroup workerGroup = NettyUtils.createEventLoop(ioMode, this.conf.serverThreads(), this.conf.getModuleName() + "-server");
        String name = System.getProperty("os.name");
        boolean isNotWindows = !name.regionMatches(true, 0, "Windows", 0, 7);
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.getServerChannelClass(ioMode))).option(ChannelOption.ALLOCATOR, (Object)this.pooledAllocator)).option(ChannelOption.SO_REUSEADDR, (Object)isNotWindows)).childOption(ChannelOption.ALLOCATOR, (Object)this.pooledAllocator);
        this.metrics = new NettyMemoryMetrics(this.pooledAllocator, this.conf.getModuleName() + "-server", this.conf);
        if (this.conf.backLog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conf.backLog());
        }
        if (this.conf.receiveBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.conf.sendBuf());
        }
        if (this.conf.enableTcpKeepAlive()) {
            this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                logger.debug("New connection accepted for remote address {}.", (Object)ch.remoteAddress());
                RpcHandler rpcHandler = TransportServer.this.appRpcHandler;
                for (TransportServerBootstrap bootstrap : TransportServer.this.bootstraps) {
                    rpcHandler = bootstrap.doBootstrap((Channel)ch, rpcHandler);
                }
                TransportServer.this.context.initializePipeline(ch, rpcHandler, false);
            }
        });
        InetSocketAddress address = hostToBind == null ? new InetSocketAddress(portToBind) : new InetSocketAddress(hostToBind, portToBind);
        this.channelFuture = this.bootstrap.bind((SocketAddress)address);
        this.channelFuture.syncUninterruptibly();
        InetSocketAddress localAddress = (InetSocketAddress)this.channelFuture.channel().localAddress();
        this.port = localAddress.getPort();
        logger.debug("Shuffle server started on {} with port {}", (Object)localAddress.getHostString(), (Object)this.port);
    }

    public MetricSet getAllMetrics() {
        return this.metrics;
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.config().group() != null) {
            this.bootstrap.config().group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.config().childGroup() != null) {
            this.bootstrap.config().childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }

    public Counter getRegisteredConnections() {
        return this.context.getRegisteredConnections();
    }
}

