/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ResourceBundle;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

class SequenceFaultFactory {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SequenceFaultFactory.class);
    private final RMConstants constants;

    SequenceFaultFactory(RMConstants consts) {
        this.constants = consts;
    }

    SequenceFault createUnknownSequenceFault(Identifier sid) {
        Message msg = new Message("UNKNOWN_SEQ_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setDetail(sid);
        fault.setSender(true);
        fault.setFaultCode(this.constants.getUnknownSequenceFaultCode());
        return fault;
    }

    SequenceFault createSequenceTerminatedFault(Identifier sid, boolean sender) {
        Message msg = new Message("SEQ_TERMINATED_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setDetail(sid);
        fault.setSender(sender);
        fault.setFaultCode(this.constants.getSequenceTerminatedFaultCode());
        return fault;
    }

    SequenceFault createInvalidAcknowledgementFault(SequenceAcknowledgement ack) {
        Message msg = new Message("INVALID_ACK_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setDetail(ack);
        fault.setSender(true);
        fault.setFaultCode(this.constants.getInvalidAcknowledgmentFaultCode());
        return fault;
    }

    SequenceFault createMessageNumberRolloverFault(Identifier sid) {
        Message msg = new Message("MESSAGE_NR_ROLLOVER_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setDetail(sid);
        fault.setSender(true);
        fault.setFaultCode(this.constants.getMessageNumberRolloverFaultCode());
        return fault;
    }

    SequenceFault createCreateSequenceRefusedFault() {
        Message msg = new Message("CREATE_SEQ_REFUSED", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSender(true);
        fault.setFaultCode(this.constants.getCreateSequenceRefusedFaultCode());
        return fault;
    }
}

