/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json;

import java.util.Map;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.connector.DeserializationFormat;
import org.apache.seatunnel.api.table.connector.SerializationFormat;
import org.apache.seatunnel.api.table.factory.DeserializationFormatFactory;
import org.apache.seatunnel.api.table.factory.SerializationFormatFactory;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.format.json.JsonFormatOptions;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class JsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "json";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public OptionRule optionRule() {
        return OptionRule.builder().build();
    }

    public DeserializationFormat createDeserializationFormat(TableFactoryContext context) {
        Map options = context.getOptions().toMap();
        final boolean failOnMissingField = JsonFormatOptions.getFailOnMissingField(options);
        final boolean ignoreParseErrors = JsonFormatOptions.getIgnoreParseErrors(options);
        return new DeserializationFormat(){

            public DeserializationSchema createDeserializationSchema() {
                return new JsonDeserializationSchema(failOnMissingField, ignoreParseErrors, null);
            }
        };
    }

    public SerializationFormat createSerializationFormat(TableFactoryContext context) {
        return new SerializationFormat(){

            public SerializationSchema createSerializationSchema() {
                return new JsonSerializationSchema(null);
            }
        };
    }
}

