/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;

public class DataTypeConvertException
extends SeaTunnelRuntimeException {
    private static final String CONVERT_TO_SEA_TUNNEL_ERROR_MSG = "Convert type: %s to SeaTunnel data type error.";
    private static final String CONVERT_TO_CONNECTOR_DATA_TYPE_ERROR_MSG = "Convert SeaTunnel data type: %s to connector data type error.";

    public DataTypeConvertException(String message) {
        this(message, null);
    }

    public DataTypeConvertException(String message, Throwable cause) {
        super(CommonErrorCode.UNSUPPORTED_DATA_TYPE, message, cause);
    }

    public static DataTypeConvertException convertToSeaTunnelDataTypeException(Object dataType) {
        return new DataTypeConvertException(String.format(CONVERT_TO_SEA_TUNNEL_ERROR_MSG, dataType));
    }

    public static DataTypeConvertException convertToSeaTunnelDataTypeException(Object dataType, Throwable cause) {
        return new DataTypeConvertException(String.format(CONVERT_TO_SEA_TUNNEL_ERROR_MSG, dataType), cause);
    }

    public static DataTypeConvertException convertToConnectorDataTypeException(SeaTunnelDataType<?> seaTunnelDataType) {
        return new DataTypeConvertException(String.format(CONVERT_TO_CONNECTOR_DATA_TYPE_ERROR_MSG, seaTunnelDataType));
    }

    public static DataTypeConvertException convertToConnectorDataTypeException(SeaTunnelDataType<?> seaTunnelDataType, Throwable cause) {
        return new DataTypeConvertException(String.format(CONVERT_TO_CONNECTOR_DATA_TYPE_ERROR_MSG, seaTunnelDataType), cause);
    }
}

