export const clearSelection = (function () {
    if (typeof document == 'undefined')
        return function () { };
    const doc = document;
    if (doc.selection) {
        return function () {
            doc.selection.empty();
        };
    }
    if (window.getSelection) {
        return function () {
            const selection = window.getSelection();
            if (selection) {
                if (selection.empty) {
                    selection.empty();
                }
                else if (selection.removeAllRanges) {
                    selection.removeAllRanges();
                }
            }
        };
    }
    return function () { };
})();
//# sourceMappingURL=selection.js.map