/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.transaction;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class TransactionListenerImpl
implements TransactionListener {
    private AtomicInteger transactionIndex = new AtomicInteger(0);
    private ConcurrentHashMap<String, Integer> localTrans = new ConcurrentHashMap();

    public LocalTransactionState executeLocalTransaction(Message msg, Object arg) {
        int value = this.transactionIndex.getAndIncrement();
        int status = value % 3;
        this.localTrans.put(msg.getTransactionId(), status);
        return LocalTransactionState.UNKNOW;
    }

    public LocalTransactionState checkLocalTransaction(MessageExt msg) {
        Integer status = this.localTrans.get(msg.getTransactionId());
        if (null != status) {
            switch (status) {
                case 0: {
                    return LocalTransactionState.UNKNOW;
                }
                case 1: {
                    return LocalTransactionState.COMMIT_MESSAGE;
                }
                case 2: {
                    return LocalTransactionState.ROLLBACK_MESSAGE;
                }
            }
            return LocalTransactionState.COMMIT_MESSAGE;
        }
        return LocalTransactionState.COMMIT_MESSAGE;
    }
}

