/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HashTableNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaterializeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class ProjectRestrictNode
extends SingleChildResultSetNode {
    ValueNode restriction;
    ValueNode constantRestriction = null;
    PredicateList restrictionList;
    SubqueryList projectSubquerys;
    SubqueryList restrictSubquerys;
    private boolean accessPathModified;
    private boolean getTableNumberHere;
    private boolean validatingCheckConstraints = false;
    private String validatingBaseTableUUIDString;

    ProjectRestrictNode(ResultSetNode resultSetNode, ResultColumnList resultColumnList, ValueNode valueNode, PredicateList predicateList, SubqueryList subqueryList, SubqueryList subqueryList2, Properties properties, ContextManager contextManager) {
        super(resultSetNode, properties, contextManager);
        this.setResultColumns(resultColumnList);
        this.restriction = valueNode;
        this.restrictionList = predicateList;
        this.projectSubquerys = subqueryList;
        this.restrictSubquerys = subqueryList2;
        if (properties != null && resultSetNode instanceof Optimizable) {
            ((Optimizable)((Object)resultSetNode)).setProperties(this.getProperties());
            this.setProperties(null);
        }
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, RowOrdering rowOrdering) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).nextAccessPath(optimizer, this.restrictionList, rowOrdering);
        }
        return super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering);
    }

    @Override
    public void rememberAsBest(int n, Optimizer optimizer) throws StandardException {
        super.rememberAsBest(n, optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberAsBest(n, optimizer);
        }
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).startOptimizing(optimizer, rowOrdering);
        } else {
            super.startOptimizing(optimizer, rowOrdering);
        }
    }

    @Override
    public int getTableNumber() {
        if (this.getTableNumberHere) {
            return super.getTableNumber();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTableNumber();
        }
        return super.getTableNumber();
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.updateBestPlanMap((short)1, this);
        if (this.childResult instanceof Optimizable) {
            CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, this.restrictionList, costEstimate, rowOrdering);
            this.getCostEstimate().setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.singleScanRowCount());
        } else if (!this.accessPathModified) {
            this.childResult = this.childResult.optimize(optimizer.getDataDictionary(), this.restrictionList, costEstimate.rowCount());
            CostEstimate costEstimate3 = this.childResult.getCostEstimate();
            this.getCostEstimate().setCost(costEstimate3.getEstimatedCost(), costEstimate3.rowCount(), costEstimate3.singleScanRowCount());
            optimizer.considerCost(this, this.restrictionList, this.getCostEstimate(), costEstimate);
        }
        return this.getCostEstimate();
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            return ((Optimizable)((Object)this.childResult)).feasibleJoinStrategy(this.restrictionList, optimizer);
        }
        return super.feasibleJoinStrategy(this.restrictionList, optimizer);
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getCurrentAccessPath();
        }
        return super.getCurrentAccessPath();
    }

    @Override
    public AccessPath getBestAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestAccessPath();
        }
        return super.getBestAccessPath();
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestSortAvoidancePath();
        }
        return super.getBestSortAvoidancePath();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    @Override
    public void rememberSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberSortAvoidancePath();
        } else {
            super.rememberSortAvoidancePath();
        }
    }

    @Override
    public boolean considerSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).considerSortAvoidancePath();
        }
        return super.considerSortAvoidancePath();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        Predicate predicate = (Predicate)optimizablePredicate;
        if (!predicate.remapScopedPred()) {
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
        }
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.restrictionList != null && !this.isNotExists()) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(false);
            for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
                OptimizablePredicate optimizablePredicate = this.restrictionList.getOptPredicate(i);
                ((Predicate)optimizablePredicate).getAndNode().accept(remapCRsVisitor);
                optimizablePredicateList.addOptPredicate(optimizablePredicate);
                this.restrictionList.removeOptPredicate(i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        boolean bl;
        boolean bl2 = true;
        if (this.accessPathModified) {
            return this;
        }
        boolean bl3 = false;
        if (!(this.childResult instanceof Optimizable)) {
            bl2 = false;
            this.childResult = this.childResult.modifyAccessPaths(this.restrictionList);
            this.hasTrulyTheBestAccessPath = true;
            if (!this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(jBitSet));
            this.getTableNumberHere = true;
        } else if (!(this.childResult instanceof FromBaseTable)) {
            if (this.trulyTheBestAccessPath.getJoinStrategy() == null) {
                this.trulyTheBestAccessPath = (AccessPathImpl)((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
            }
            if (this.childResult instanceof SetOperatorNode) {
                this.childResult = (ResultSetNode)((Object)((SetOperatorNode)this.childResult).modifyAccessPath(jBitSet, this.restrictionList));
                bl3 = true;
            } else {
                this.childResult = (ResultSetNode)((Object)((FromTable)this.childResult).modifyAccessPath(jBitSet));
            }
        }
        boolean bl4 = bl = this.hasTrulyTheBestAccessPath && this.trulyTheBestAccessPath.getJoinStrategy() != null && this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin();
        if (!(this.restrictionList == null || bl3 || bl || this.validatingCheckConstraints)) {
            this.restrictionList.pushUsefulPredicates((Optimizable)((Object)this.childResult));
        }
        if (bl2) {
            this.childResult = this.childResult.changeAccessPath();
        }
        this.accessPathModified = true;
        if (this.trulyTheBestAccessPath.getJoinStrategy() == null || !this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(jBitSet));
        return this.replaceWithHashTableNode();
    }

    private Optimizable replaceWithHashTableNode() throws StandardException {
        Object object2;
        if (this.hasTrulyTheBestAccessPath) {
            ((FromTable)this.childResult).trulyTheBestAccessPath = (AccessPathImpl)this.getTrulyTheBestAccessPath();
            if (this.childResult instanceof SingleChildResultSetNode) {
                ((SingleChildResultSetNode)this.childResult).hasTrulyTheBestAccessPath = this.hasTrulyTheBestAccessPath;
                this.childResult.getReferencedTableMap().set(this.tableNumber);
            }
        }
        PredicateList predicateList = new PredicateList(this.getContextManager());
        PredicateList predicateList2 = new PredicateList(this.getContextManager());
        PredicateList predicateList3 = new PredicateList(this.getContextManager());
        this.trulyTheBestAccessPath.getJoinStrategy().divideUpPredicateLists(this, this.restrictionList, predicateList, predicateList2, predicateList3, this.getDataDictionary());
        this.restrictionList = new PredicateList(this.getContextManager());
        for (Object object2 : predicateList) {
            predicateList3.removeOptPredicate((OptimizablePredicate)object2);
        }
        for (Object object2 : predicateList2) {
            predicateList3.removeOptPredicate((OptimizablePredicate)object2);
        }
        predicateList2.transferNonQualifiers(this, this.restrictionList);
        predicateList3.copyPredicatesToOtherList(this.restrictionList);
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        this.childResult.setResultColumns(resultColumnList.copyListAndObjects());
        resultColumnList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns(), false);
        object2 = new RemapCRsVisitor(true);
        predicateList.accept((Visitor)object2);
        this.childResult = new HashTableNode(this.childResult, this.tableProperties, resultColumnList, predicateList, predicateList2, this.trulyTheBestAccessPath, this.getCostEstimate(), this.projectSubquerys, this.restrictSubquerys, this.hashKeyColumns(), this.getContextManager());
        return this;
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).verifyProperties(dataDictionary);
        } else {
            super.verifyProperties(dataDictionary);
        }
    }

    @Override
    public boolean legalJoinOrder(JBitSet jBitSet) {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).legalJoinOrder(jBitSet);
        }
        return true;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).uniqueJoin(optimizablePredicateList);
        }
        return super.uniqueJoin(optimizablePredicateList);
    }

    PredicateList getRestrictionList() {
        return this.restrictionList;
    }

    @Override
    String getUserSpecifiedJoinStrategy() {
        if (this.childResult instanceof FromTable) {
            return ((FromTable)this.childResult).getUserSpecifiedJoinStrategy();
        }
        return this.userSpecifiedJoinStrategy;
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(n, groupByList, fromList);
        this.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
        return this;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        SelectNode selectNode;
        PredicateList predicateList2;
        if (this.childResult instanceof JoinNode) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
        if ((predicateList2 = predicateList.getPushablePredicates(this.getReferencedTableMap())) != null && this.childResult instanceof SelectNode && !(selectNode = (SelectNode)this.childResult).hasWindows() && !selectNode.hasOffsetFetchFirst()) {
            predicateList2.pushExpressionsIntoSelect((SelectNode)this.childResult, false);
        }
        if (predicateList2 != null && this.childResult instanceof UnionNode) {
            ((UnionNode)this.childResult).pushExpressions(predicateList2);
        }
        if (this.restrictionList == null) {
            this.restrictionList = predicateList2;
        } else if (predicateList2 != null && predicateList2.size() != 0) {
            this.restrictionList.destructiveAppend(predicateList2);
        }
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate(predicate);
        return this;
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, this.restrictionList, d);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    CostEstimate getCostEstimate() {
        if (super.getCostEstimate() == null) {
            return this.childResult.getCostEstimate();
        }
        return super.getCostEstimate();
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        if (this.childResult instanceof Optimizable) {
            this.setCandidateFinalCostEstimate(this.childResult.getFinalCostEstimate());
        } else {
            this.setCandidateFinalCostEstimate(this.getTrulyTheBestAccessPath().getCostEstimate());
        }
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.childResult instanceof FromVTI) {
            ((FromVTI)this.childResult).computeProjectionAndRestriction(this.restrictionList);
        }
        this.generateMinion(activationClassBuilder, methodBuilder, false);
    }

    @Override
    void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateMinion(expressionClassBuilder, methodBuilder, true);
    }

    private void generateMinion(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        if (this.restrictionList != null && this.restrictionList.size() > 0) {
            this.restrictionList.eliminateBooleanTrueAndBooleanTrue();
        }
        if (this.nopProjectRestrict()) {
            this.generateNOPProjectRestrict();
            if (bl) {
                this.childResult.generateResultSet(expressionClassBuilder, methodBuilder);
            } else {
                this.childResult.generate((ActivationClassBuilder)expressionClassBuilder, methodBuilder);
            }
            this.setCostEstimate(this.childResult.getFinalCostEstimate());
            return;
        }
        if (this.restrictionList != null) {
            this.constantRestriction = this.restrictionList.restoreConstantPredicates();
            this.restrictionList.removeRedundantPredicates();
            this.restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        ResultColumnList.ColumnMapping columnMapping = this.getResultColumns().mapSourceColumns();
        int[] nArray = columnMapping.mapArray;
        boolean[] blArray = columnMapping.cloneMap;
        int n = expressionClassBuilder.addItem(new ReferencedColumnsDescriptorImpl(nArray));
        int n2 = expressionClassBuilder.addItem(blArray);
        boolean bl2 = true;
        if (!this.reflectionNeededForProjection() && nArray != null && nArray.length == this.childResult.getResultColumns().size()) {
            int n3;
            for (n3 = 0; n3 < nArray.length && nArray[n3] == n3 + 1; ++n3) {
            }
            if (n3 == nArray.length) {
                bl2 = false;
            }
        }
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        if (bl) {
            this.childResult.generateResultSet(expressionClassBuilder, methodBuilder);
        } else {
            this.childResult.generate((ActivationClassBuilder)expressionClassBuilder, methodBuilder);
        }
        this.assignResultSetNumber();
        if (this.projectSubquerys != null && this.projectSubquerys.size() > 0) {
            this.projectSubquerys.setPointOfAttachment(this.getResultSetNumber());
        }
        if (this.restrictSubquerys != null && this.restrictSubquerys.size() > 0) {
            this.restrictSubquerys.setPointOfAttachment(this.getResultSetNumber());
        }
        this.setCostEstimate(this.getFinalCostEstimate());
        if (this.restriction == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
            this.restriction.generateExpression(expressionClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        if (this.reflectionNeededForProjection()) {
            this.getResultColumns().generateCore(expressionClassBuilder, methodBuilder, false);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        methodBuilder.push(this.getResultSetNumber());
        if (this.constantRestriction == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder3 = expressionClassBuilder.newUserExprFun();
            this.constantRestriction.generateExpression(expressionClassBuilder, methodBuilder3);
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder3);
        }
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.push(this.getResultColumns().reusableResult());
        methodBuilder.push(bl2);
        methodBuilder.push(this.validatingCheckConstraints);
        if (this.validatingBaseTableUUIDString == null) {
            methodBuilder.push("NULL");
        } else {
            methodBuilder.push(this.validatingBaseTableUUIDString);
        }
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getProjectRestrictResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    boolean nopProjectRestrict() {
        if (this.restriction != null || this.constantRestriction != null || this.restrictionList != null && this.restrictionList.size() > 0) {
            return false;
        }
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.getResultColumns();
        return resultColumnList2.nopProjection(resultColumnList);
    }

    void generateNOPProjectRestrict() throws StandardException {
        this.getResultColumns().setRedundant();
    }

    @Override
    ResultSetNode considerMaterialization(JBitSet jBitSet) throws StandardException {
        this.childResult = this.childResult.considerMaterialization(jBitSet);
        if (this.childResult.performMaterialization(jBitSet)) {
            boolean bl;
            ReferencedTablesVisitor referencedTablesVisitor = new ReferencedTablesVisitor((JBitSet)this.childResult.getReferencedTableMap().clone());
            boolean bl2 = bl = this.restrictionList == null || this.restrictionList.size() == 0;
            if (!bl) {
                this.restrictionList.accept(referencedTablesVisitor);
            }
            if (bl || this.childResult.getReferencedTableMap().contains(referencedTablesVisitor.getTableMap())) {
                ResultColumnList resultColumnList = this.getResultColumns();
                this.setResultColumns(this.getResultColumns().copyListAndObjects());
                resultColumnList.genVirtualColumnNodes(this, this.getResultColumns());
                MaterializeResultSetNode materializeResultSetNode = new MaterializeResultSetNode(this, resultColumnList, this.tableProperties, this.getContextManager());
                if (this.getReferencedTableMap() != null) {
                    materializeResultSetNode.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
                }
                return materializeResultSetNode;
            }
            ResultColumnList resultColumnList = this.childResult.getResultColumns();
            this.childResult.setResultColumns(resultColumnList.copyListAndObjects());
            resultColumnList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns());
            MaterializeResultSetNode materializeResultSetNode = new MaterializeResultSetNode(this.childResult, resultColumnList, this.tableProperties, this.getContextManager());
            if (this.childResult.getReferencedTableMap() != null) {
                materializeResultSetNode.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
            }
            this.childResult = materializeResultSetNode;
        }
        return this;
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.childResult.getFromTableByName(string, string2, bl);
    }

    @Override
    int updateTargetLockMode() {
        if (this.restriction != null || this.constantRestriction != null) {
            return 6;
        }
        return this.childResult.updateTargetLockMode();
    }

    @Override
    boolean isPossibleDistinctScan(Set<BaseColumnNode> set) {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<BaseColumnNode> hashSet = new HashSet<BaseColumnNode>();
        for (ResultColumn resultColumn : this.getResultColumns()) {
            BaseColumnNode baseColumnNode = resultColumn.getBaseColumnNode();
            if (baseColumnNode == null) {
                return false;
            }
            hashSet.add(baseColumnNode);
        }
        return hashSet.equals(set) && this.childResult.isPossibleDistinctScan(set);
    }

    @Override
    void markForDistinctScan() {
        this.childResult.markForDistinctScan();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.restriction != null) {
            this.restriction = (ValueNode)this.restriction.accept(visitor);
        }
        if (this.restrictionList != null) {
            this.restrictionList = (PredicateList)this.restrictionList.accept(visitor);
        }
    }

    @Override
    void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
        this.childResult.setRefActionInfo(l, nArray, string, bl);
    }

    void setRestriction(ValueNode valueNode) {
        this.restriction = valueNode;
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.childResult.pushQueryExpressionSuffix();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.childResult.pushOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.childResult.pushOffsetFetchFirst(valueNode, valueNode2, bl);
    }

    void setValidatingCheckConstraints(String string) {
        this.validatingCheckConstraints = true;
        this.validatingBaseTableUUIDString = string;
    }
}

