/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.ContentSummary;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TestContentSummary {
    @Test
    public void testConstructorEmpty() {
        ContentSummary contentSummary = new ContentSummary.Builder().build();
        Assert.assertEquals((String)"getLength", (long)0L, (long)contentSummary.getLength());
        Assert.assertEquals((String)"getFileCount", (long)0L, (long)contentSummary.getFileCount());
        Assert.assertEquals((String)"getDirectoryCount", (long)0L, (long)contentSummary.getDirectoryCount());
        Assert.assertEquals((String)"getQuota", (long)-1L, (long)contentSummary.getQuota());
        Assert.assertEquals((String)"getSpaceConsumed", (long)0L, (long)contentSummary.getSpaceConsumed());
        Assert.assertEquals((String)"getSpaceQuota", (long)-1L, (long)contentSummary.getSpaceQuota());
    }

    @Test
    public void testConstructorWithQuota() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66666L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        Assert.assertEquals((String)"getLength", (long)length, (long)contentSummary.getLength());
        Assert.assertEquals((String)"getFileCount", (long)fileCount, (long)contentSummary.getFileCount());
        Assert.assertEquals((String)"getDirectoryCount", (long)directoryCount, (long)contentSummary.getDirectoryCount());
        Assert.assertEquals((String)"getQuota", (long)quota, (long)contentSummary.getQuota());
        Assert.assertEquals((String)"getSpaceConsumed", (long)spaceConsumed, (long)contentSummary.getSpaceConsumed());
        Assert.assertEquals((String)"getSpaceQuota", (long)spaceQuota, (long)contentSummary.getSpaceQuota());
    }

    @Test
    public void testConstructorNoQuota() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).spaceConsumed(length).build();
        Assert.assertEquals((String)"getLength", (long)length, (long)contentSummary.getLength());
        Assert.assertEquals((String)"getFileCount", (long)fileCount, (long)contentSummary.getFileCount());
        Assert.assertEquals((String)"getDirectoryCount", (long)directoryCount, (long)contentSummary.getDirectoryCount());
        Assert.assertEquals((String)"getQuota", (long)-1L, (long)contentSummary.getQuota());
        Assert.assertEquals((String)"getSpaceConsumed", (long)length, (long)contentSummary.getSpaceConsumed());
        Assert.assertEquals((String)"getSpaceQuota", (long)-1L, (long)contentSummary.getSpaceQuota());
    }

    @Test
    public void testWrite() throws IOException {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66666L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        DataOutput out = (DataOutput)Mockito.mock(DataOutput.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        contentSummary.write(out);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(length);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(fileCount);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(directoryCount);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(quota);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(spaceConsumed);
        ((DataOutput)inOrder.verify((Object)out)).writeLong(spaceQuota);
    }

    @Test
    public void testReadFields() throws IOException {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66666L;
        ContentSummary contentSummary = new ContentSummary.Builder().build();
        DataInput in = (DataInput)Mockito.mock(DataInput.class);
        Mockito.when((Object)in.readLong()).thenReturn((Object)length).thenReturn((Object)fileCount).thenReturn((Object)directoryCount).thenReturn((Object)quota).thenReturn((Object)spaceConsumed).thenReturn((Object)spaceQuota);
        contentSummary.readFields(in);
        Assert.assertEquals((String)"getLength", (long)length, (long)contentSummary.getLength());
        Assert.assertEquals((String)"getFileCount", (long)fileCount, (long)contentSummary.getFileCount());
        Assert.assertEquals((String)"getDirectoryCount", (long)directoryCount, (long)contentSummary.getDirectoryCount());
        Assert.assertEquals((String)"getQuota", (long)quota, (long)contentSummary.getQuota());
        Assert.assertEquals((String)"getSpaceConsumed", (long)spaceConsumed, (long)contentSummary.getSpaceConsumed());
        Assert.assertEquals((String)"getSpaceQuota", (long)spaceQuota, (long)contentSummary.getSpaceQuota());
    }

    @Test
    public void testGetHeaderWithQuota() {
        String header = "  name quota  rem name quota     space quota rem space quota  directories        files              bytes ";
        Assert.assertEquals((Object)header, (Object)ContentSummary.getHeader((boolean)true));
    }

    @Test
    public void testGetHeaderNoQuota() {
        String header = " directories        files              bytes ";
        Assert.assertEquals((Object)header, (Object)ContentSummary.getHeader((boolean)false));
    }

    @Test
    public void testToStringWithQuota() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66665L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "       44444          -11111           66665           11110        33333        22222              11111 ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString(true));
    }

    @Test
    public void testToStringNoQuota() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).build();
        String expected = "        none             inf            none             inf        33333        22222              11111 ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString(true));
    }

    @Test
    public void testToStringNoShowQuota() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66665L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "       33333        22222              11111 ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString(false));
    }

    @Test
    public void testToString() {
        long length = 11111L;
        long fileCount = 22222L;
        long directoryCount = 33333L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66665L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "       44444          -11111           66665           11110        33333        22222              11111 ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString());
    }

    @Test
    public void testToStringHumanWithQuota() {
        long length = Long.MAX_VALUE;
        long fileCount = 222222222L;
        long directoryCount = 33333L;
        long quota = 222256578L;
        long spaceConsumed = 0x40000001L;
        long spaceQuota = 1L;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "     212.0 M            1023               1            -1 G       32.6 K      211.9 M              8.0 E ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString(true, true));
    }

    @Test
    public void testToStringHumanNoShowQuota() {
        long length = Long.MAX_VALUE;
        long fileCount = 222222222L;
        long directoryCount = 33333L;
        long quota = 222256578L;
        long spaceConsumed = 55555L;
        long spaceQuota = Long.MAX_VALUE;
        ContentSummary contentSummary = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "      32.6 K      211.9 M              8.0 E ";
        Assert.assertEquals((Object)expected, (Object)contentSummary.toString(false, true));
    }
}

