/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestRbwSpaceReservation {
    static final Log LOG = LogFactory.getLog(TestRbwSpaceReservation.class);
    private static final int DU_REFRESH_INTERVAL_MSEC = 500;
    private static final int STORAGES_PER_DATANODE = 1;
    private static final int BLOCK_SIZE = 0x100000;
    private static final int SMALL_BLOCK_SIZE = 1024;
    protected MiniDFSCluster cluster;
    private Configuration conf;
    private DistributedFileSystem fs = null;
    private DFSClient client = null;
    FsVolumeImpl singletonVolume = null;
    private DataNodeFaultInjector old = null;
    private static Random rand = new Random();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private void initConfig(int blockSize) {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("fs.du.interval", 500);
        this.conf.setLong("dfs.blocksize", (long)blockSize);
        this.conf.setInt("dfs.datanode.scan.period.hours", -1);
    }

    private void startCluster(int blockSize, int numDatanodes, long perVolumeCapacity) throws IOException {
        this.initConfig(blockSize);
        this.cluster = new MiniDFSCluster.Builder(this.conf).storagesPerDatanode(1).numDataNodes(numDatanodes).build();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        this.cluster.waitActive();
        if (perVolumeCapacity >= 0L) {
            for (DataNode dn : this.cluster.getDataNodes()) {
                for (FsVolumeSpi volume : dn.getFSDataset().getVolumes()) {
                    ((FsVolumeImpl)volume).setCapacityForTesting(perVolumeCapacity);
                }
            }
        }
        if (numDatanodes == 1) {
            List volumes = this.cluster.getDataNodes().get(0).getFSDataset().getVolumes();
            Assert.assertThat((Object)volumes.size(), (Matcher)Is.is((Object)1));
            this.singletonVolume = (FsVolumeImpl)volumes.get(0);
        }
    }

    @After
    public void shutdownCluster() throws IOException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileAndTestSpaceReservation(String fileNamePrefix, int fileBlockSize) throws IOException, InterruptedException {
        long configuredCapacity = fileBlockSize * 2 - 1;
        this.startCluster(0x100000, 1, configuredCapacity);
        Path path = new Path("/" + fileNamePrefix + ".dat");
        try (FSDataOutputStream out = null;){
            out = this.fs.create(path, false, 4096, (short)1, (long)fileBlockSize);
            byte[] buffer = new byte[rand.nextInt(fileBlockSize / 4)];
            out.write(buffer);
            out.hsync();
            int bytesWritten = buffer.length;
            Assert.assertThat((Object)this.singletonVolume.getReservedForRbw(), (Matcher)Is.is((Object)((long)fileBlockSize - (long)bytesWritten)));
            out.close();
            out = null;
            Assert.assertThat((Object)this.singletonVolume.getReservedForRbw(), (Matcher)Is.is((Object)0L));
            out = this.fs.append(path);
            out.write(buffer);
            out.hsync();
            Assert.assertThat((Object)this.singletonVolume.getReservedForRbw(), (Matcher)Is.is((Object)((long)fileBlockSize - (long)(bytesWritten += buffer.length))));
            out.write(buffer);
            out.hsync();
            Assert.assertThat((Object)this.singletonVolume.getReservedForRbw(), (Matcher)Is.is((Object)((long)fileBlockSize - (long)(bytesWritten += buffer.length))));
        }
    }

    @Test(timeout=300000L)
    public void testWithDefaultBlockSize() throws IOException, InterruptedException {
        this.createFileAndTestSpaceReservation(GenericTestUtils.getMethodName(), 0x100000);
    }

    @Test(timeout=300000L)
    public void testWithNonDefaultBlockSize() throws IOException, InterruptedException {
        this.createFileAndTestSpaceReservation(GenericTestUtils.getMethodName(), 0x200000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithLimitedSpace() throws IOException {
        this.startCluster(0x100000, 1, 0x1FFFFFL);
        String methodName = GenericTestUtils.getMethodName();
        Path file1 = new Path("/" + methodName + ".01.dat");
        Path file2 = new Path("/" + methodName + ".02.dat");
        FSDataOutputStream os2 = null;
        try (FSDataOutputStream os1 = null;){
            os1 = this.fs.create(file1);
            os2 = this.fs.create(file2);
            byte[] data = new byte[1];
            os1.write(data);
            os1.hsync();
            this.thrown.expect(RemoteException.class);
            os2.write(data);
            os2.hsync();
        }
    }

    @Test(timeout=300000L)
    public void testSpaceReleasedOnUnexpectedEof() throws IOException, InterruptedException, TimeoutException {
        int replication = 3;
        this.startCluster(0x100000, 3, -1L);
        String methodName = GenericTestUtils.getMethodName();
        Path file = new Path("/" + methodName + ".01.dat");
        FSDataOutputStream os = this.fs.create(file, (short)3);
        os.write(new byte[1]);
        os.hsync();
        DFSTestUtil.abortStream((DFSOutputStream)os.getWrappedStream());
        for (DataNode dn : this.cluster.getDataNodes()) {
            final FsVolumeImpl volume = (FsVolumeImpl)dn.getFSDataset().getVolumes().get(0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return volume.getReservedForRbw() == 0L;
                }
            }, (int)500, (int)Integer.MAX_VALUE);
        }
    }

    @Test(timeout=30000L)
    public void testRBWFileCreationError() throws Exception {
        boolean replication = true;
        this.startCluster(0x100000, 1, -1L);
        FsVolumeImpl fsVolumeImpl = (FsVolumeImpl)this.cluster.getDataNodes().get(0).getFSDataset().getVolumes().get(0);
        String methodName = GenericTestUtils.getMethodName();
        Path file = new Path("/" + methodName + ".01.dat");
        BlockPoolSlice blockPoolSlice = (BlockPoolSlice)Mockito.mock(BlockPoolSlice.class);
        Mockito.when((Object)blockPoolSlice.createRbwFile((Block)Mockito.any())).thenThrow(new Throwable[]{new IOException("Synthetic IO Exception Throgh MOCK")});
        Field field = FsVolumeImpl.class.getDeclaredField("bpSlices");
        field.setAccessible(true);
        Map bpSlices = (Map)field.get(fsVolumeImpl);
        bpSlices.put(fsVolumeImpl.getBlockPoolList()[0], blockPoolSlice);
        try {
            FSDataOutputStream os = this.fs.create(file, (short)1);
            os.write(new byte[1]);
            os.hsync();
            os.close();
            Assert.fail((String)"Expecting IOException file creation failure");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Expected ZERO but got " + fsVolumeImpl.getReservedForRbw()), (fsVolumeImpl.getReservedForRbw() == 0L ? 1 : 0) != 0);
    }

    @Test(timeout=600000L)
    public void stressTest() throws IOException, InterruptedException {
        int numWriters = 5;
        this.startCluster(1024, 1, 51200L);
        Writer[] writers = new Writer[5];
        for (int i = 0; i < 5; ++i) {
            writers[i] = new Writer(this.client, 1024);
            writers[i].start();
        }
        Thread.sleep(60000L);
        for (Writer w : writers) {
            w.stopWriter();
        }
        int filesCreated = 0;
        int numFailures = 0;
        for (Writer w : writers) {
            w.join();
            filesCreated += w.getFilesCreated();
            numFailures += w.getNumFailures();
        }
        LOG.info((Object)("Stress test created " + filesCreated + " files and hit " + numFailures + " failures"));
        Assert.assertThat((Object)this.singletonVolume.getReservedForRbw(), (Matcher)Is.is((Object)0L));
    }

    @Test(timeout=30000L)
    public void testReservedSpaceForAppend() throws Exception {
        int replication = 3;
        this.startCluster(0x100000, 3, -1L);
        String methodName = GenericTestUtils.getMethodName();
        Path file = new Path("/" + methodName + ".01.dat");
        FSDataOutputStream os = this.fs.create(file, (short)3);
        os.write(new byte[1024]);
        os.close();
        Path file2 = new Path("/" + methodName + ".02.dat");
        FSDataOutputStream os2 = this.fs.create(file2, (short)3);
        os2.write(new byte[1]);
        os2.hflush();
        int expectedFile2Reserved = 1048575;
        this.checkReservedSpace(expectedFile2Reserved);
        os = this.fs.append(file);
        os.write(new byte[1]);
        os.hflush();
        int expectedFile1Reserved = 1047551;
        this.checkReservedSpace(expectedFile2Reserved + expectedFile1Reserved);
        os.close();
        this.checkReservedSpace(expectedFile2Reserved);
        os = this.fs.append(file);
        os.write(new byte[1]);
        os.hflush();
        this.checkReservedSpace(expectedFile2Reserved + --expectedFile1Reserved);
        DFSTestUtil.abortStream((DFSOutputStream)os.getWrappedStream());
        this.checkReservedSpace(expectedFile2Reserved);
    }

    @Test(timeout=30000L)
    public void testReservedSpaceForPipelineRecovery() throws Exception {
        int replication = 3;
        this.startCluster(0x100000, 3, -1L);
        String methodName = GenericTestUtils.getMethodName();
        Path file = new Path("/" + methodName + ".01.dat");
        this.old = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){
            private int tries = 0;

            public void failMirrorConnection() throws IOException {
                if (this.tries++ == 0) {
                    throw new IOException("Failing Mirror for space reservation");
                }
            }
        });
        FSDataOutputStream os = this.fs.create(file, (short)3);
        os.write(new byte[1]);
        os.close();
        this.cluster.triggerBlockReports();
        for (final DataNode dn : this.cluster.getDataNodes()) {
            for (FsVolumeSpi fsVolume : dn.getFSDataset().getVolumes()) {
                final FsVolumeImpl volume = (FsVolumeImpl)fsVolume;
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    public Boolean get() {
                        LOG.info((Object)("dn " + dn.getDisplayName() + " space : " + volume.getReservedForRbw()));
                        return volume.getReservedForRbw() == 0L;
                    }
                }, (int)100, (int)Integer.MAX_VALUE);
            }
        }
    }

    private void checkReservedSpace(final long expectedReserved) throws TimeoutException, InterruptedException, IOException {
        for (final DataNode dn : this.cluster.getDataNodes()) {
            for (FsVolumeSpi fsVolume : dn.getFSDataset().getVolumes()) {
                final FsVolumeImpl volume = (FsVolumeImpl)fsVolume;
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    public Boolean get() {
                        LOG.info((Object)("dn " + dn.getDisplayName() + " space : " + volume.getReservedForRbw() + ", Expected ReservedSpace :" + expectedReserved));
                        return volume.getReservedForRbw() == expectedReserved;
                    }
                }, (int)100, (int)3000);
            }
        }
    }

    static {
        ((Log4JLogger)FsDatasetImpl.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
    }

    private static class Writer
    extends Daemon {
        private volatile boolean keepRunning;
        private final DFSClient localClient;
        private int filesCreated = 0;
        private int numFailures = 0;
        byte[] data;

        Writer(DFSClient client, int blockSize) throws IOException {
            this.localClient = client;
            this.keepRunning = true;
            this.filesCreated = 0;
            this.numFailures = 0;
            this.data = new byte[blockSize * 2];
        }

        /*
         * Loose catch block
         */
        public void run() {
            while (this.keepRunning) {
                OutputStream os = null;
                try {
                    String filename = "/file-" + rand.nextLong();
                    os = this.localClient.create(filename, false);
                    os.write(this.data, 0, rand.nextInt(this.data.length));
                    IOUtils.closeQuietly((OutputStream)os);
                    os = null;
                    this.localClient.delete(filename, false);
                    Thread.sleep(50L);
                    ++this.filesCreated;
                    if (os == null) continue;
                }
                catch (IOException ioe) {
                    ++this.numFailures;
                    continue;
                }
                catch (InterruptedException ie) {
                    if (os != null) {
                        IOUtils.closeQuietly(os);
                    }
                    return;
                }
                IOUtils.closeQuietly((OutputStream)os);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (os == null) continue;
                    IOUtils.closeQuietly(os);
                }
            }
        }

        public void stopWriter() {
            this.keepRunning = false;
        }

        public int getFilesCreated() {
            return this.filesCreated;
        }

        public int getNumFailures() {
            return this.numFailures;
        }
    }
}

