/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jline.ConsoleReader;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.server.monitor.servlets.BasicServlet;

public class ShellServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, ShellExecutionThread> userShells = new HashMap<String, ShellExecutionThread>();
    private ExecutorService service = Executors.newCachedThreadPool();

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Shell";
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse response, StringBuilder sb) throws IOException {
        HttpSession session = req.getSession(true);
        String user = (String)session.getAttribute("user");
        if (user == null) {
            user = req.getParameter("user");
            String pass = req.getParameter("pass");
            String mock = req.getParameter("mock");
            if (user == null || pass == null) {
                sb.append(this.authenticationForm(req.getRequestURI()));
                return;
            }
            try {
                ShellExecutionThread shellThread = new ShellExecutionThread(user, pass, mock);
                this.service.submit(shellThread);
                this.userShells.put(session.getId(), shellThread);
            }
            catch (IOException e) {
                sb.append("<div id='loginError'>Invalid user/password</div>" + this.authenticationForm(req.getRequestURI()));
                return;
            }
            session.setAttribute("user", (Object)user);
        }
        if (!this.userShells.containsKey(session.getId())) {
            sb.append(this.authenticationForm(req.getRequestURI()));
            return;
        }
        ShellExecutionThread shellThread = this.userShells.get(session.getId());
        shellThread.getOutput();
        shellThread.printInfo();
        sb.append("<div id='shell'>\n");
        sb.append("<pre id='shellResponse'>").append(shellThread.getOutput()).append("</pre>\n");
        sb.append("<form><span id='shellPrompt'>").append(shellThread.getPrompt());
        sb.append("</span><input type='text' name='cmd' id='cmd' onkeydown='return handleKeyDown(event.keyCode);'>\n");
        sb.append("</form>\n</div>\n");
        sb.append("<script type='text/javascript'>\n");
        sb.append("var url = '").append(req.getRequestURL().toString()).append("';\n");
        sb.append("var xmlhttp = new XMLHttpRequest();\n");
        sb.append("var hsize = 1000;\n");
        sb.append("var hindex = 0;\n");
        sb.append("var history = new Array();\n");
        sb.append("\n");
        sb.append("function handleKeyDown(keyCode) {\n");
        sb.append("  if (keyCode==13) {\n");
        sb.append("    submitCmd(document.getElementById('cmd').value);\n");
        sb.append("    hindex = history.length;\n");
        sb.append("    return false;\n");
        sb.append("  } else if (keyCode==38) {\n");
        sb.append("    hindex = hindex==0 ? history.length : hindex - 1;\n");
        sb.append("    if (hindex == history.length)\n");
        sb.append("      document.getElementById('cmd').value = '';\n");
        sb.append("    else\n");
        sb.append("      document.getElementById('cmd').value = history[hindex];\n");
        sb.append("    return false;\n");
        sb.append("  } else if (keyCode==40) {\n");
        sb.append("    hindex = hindex==history.length ? history.length : hindex + 1;\n");
        sb.append("    if (hindex == history.length)\n");
        sb.append("      document.getElementById('cmd').value = '';\n");
        sb.append("    else\n");
        sb.append("      document.getElementById('cmd').value = history[hindex];\n");
        sb.append("    return false;\n");
        sb.append("  }\n");
        sb.append("  return true;\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("function submitCmd(cmd) {\n");
        sb.append("  if (cmd=='history') {\n");
        sb.append("    document.getElementById('shellResponse').innerHTML += document.getElementById('shellPrompt').innerHTML+cmd+'\\n';\n");
        sb.append("    document.getElementById('shellResponse').innerHTML += history.join('\\n');\n");
        sb.append("    return\n");
        sb.append("  }\n");
        sb.append("  xmlhttp.open('POST',url+'?cmd='+cmd,false);\n");
        sb.append("  xmlhttp.send();\n");
        sb.append("  var text = xmlhttp.responseText;\n");
        sb.append("  var index = text.lastIndexOf('\\n');\n");
        sb.append("  if (index >= 0) {\n");
        sb.append("    if (index > 0 && document.getElementById('cmd').type == 'text') {\n");
        sb.append("      if (history.length == hsize)\n");
        sb.append("        history.shift()\n");
        sb.append("      history.push(cmd)\n");
        sb.append("    }\n");
        sb.append("    if (text.charAt(text.length-1)=='*') {\n");
        sb.append("      document.getElementById('cmd').type = 'password';\n");
        sb.append("      text = text.substring(0,xmlhttp.responseText.length-2);\n");
        sb.append("    } else {\n");
        sb.append("      document.getElementById('cmd').type = 'text';\n");
        sb.append("    }\n");
        sb.append("    document.getElementById('shellResponse').innerHTML += text.substring(0,index+1);\n");
        sb.append("    document.getElementById('shellPrompt').innerHTML = text.substring(index+1);\n");
        sb.append("    document.getElementById('cmd').value = '';\n");
        sb.append("    document.getElementById('shell').scrollTop = document.getElementById('cmd').offsetTop;\n");
        sb.append("  } else {\n");
        sb.append("    window.location = url;\n");
        sb.append("  }\n");
        sb.append("}\n");
        sb.append("</script>\n");
        sb.append("<script type='text/javascript'>window.onload = function() { document.getElementById('cmd').select(); }</script>\n");
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        String user = (String)session.getAttribute("user");
        if (user == null || !this.userShells.containsKey(session.getId())) {
            this.doGet(req, resp);
            return;
        }
        ShellExecutionThread shellThread = this.userShells.get(session.getId());
        String cmd = req.getParameter("cmd");
        if (cmd == null) {
            resp.getWriter().append(shellThread.getPrompt());
            resp.getWriter().flush();
            return;
        }
        shellThread.addInputString(cmd);
        shellThread.waitUntilReady();
        if (shellThread.isDone()) {
            this.userShells.remove(session.getId());
            session.invalidate();
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(shellThread.getOutput().replace("<", "&lt;").replace(">", "&gt;"));
        if (sb.length() == 0 || sb.charAt(sb.length() - 1) != '\n') {
            sb.append("\n");
        }
        if (!shellThread.isWaitingForInput()) {
            sb.append(shellThread.getPrompt());
        }
        if (shellThread.isMasking()) {
            sb.append("*");
        }
        resp.getWriter().append(sb.toString());
        resp.getWriter().flush();
    }

    private String authenticationForm(String requestURI) {
        return "<div id='login'><form method=POST action='" + requestURI + "'>" + "<table><tr><td>Mock:&nbsp</td><td><input type='checkbox' name='mock' value='mock'></td></tr>" + "<tr><td>Username:&nbsp;</td><td><input type='text' name='user'></td></tr>" + "<tr><td>Password:&nbsp;</td><td><input type='password' name='pass'></td><td><input type='submit' value='Enter'></td></tr></table></form></div>";
    }

    private static class ShellExecutionThread
    extends InputStream
    implements Runnable {
        private Shell shell;
        StringBuilderOutputStream output = new StringBuilderOutputStream();
        private String cmd = null;
        private int cmdIndex = 0;
        private boolean done = false;
        private boolean readWait = false;

        private ShellExecutionThread(String username, String password, String mock) throws IOException {
            ConsoleReader reader = new ConsoleReader((InputStream)this, (Writer)new OutputStreamWriter(this.output));
            this.shell = new Shell(reader, new PrintWriter(this.output));
            this.shell.setLogErrorsToConsole();
            if (mock != null) {
                if (this.shell.config(new String[]{"--fake", "-u", username, "-p", password})) {
                    throw new IOException("mock shell config error");
                }
            } else if (this.shell.config(new String[]{"-u", username, "-p", password})) {
                throw new IOException("shell config error");
            }
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.cmd == null) {
                this.readWait = true;
                this.notifyAll();
            }
            while (this.cmd == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.readWait = false;
            int c = this.cmdIndex == this.cmd.length() ? 10 : (int)this.cmd.charAt(this.cmdIndex);
            ++this.cmdIndex;
            if (this.cmdIndex > this.cmd.length()) {
                this.cmd = null;
                this.cmdIndex = 0;
                this.notifyAll();
            }
            return c;
        }

        @Override
        public synchronized void run() {
            Thread.currentThread().setName("shell thread");
            while (!this.shell.hasExited()) {
                while (this.cmd == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                String tcmd = this.cmd;
                this.cmd = null;
                this.cmdIndex = 0;
                try {
                    this.shell.execCommand(tcmd, false, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.notifyAll();
            }
            this.done = true;
            this.notifyAll();
        }

        public synchronized void addInputString(String s) {
            if (this.done) {
                throw new IllegalStateException("adding string to exited shell");
            }
            if (this.cmd != null) {
                throw new IllegalStateException("adding string to shell not waiting for input");
            }
            this.cmd = s;
            this.notifyAll();
        }

        public synchronized void waitUntilReady() {
            while (this.cmd != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized String getOutput() {
            String s = this.output.get();
            this.output.clear();
            return s;
        }

        public String getPrompt() {
            return this.shell.getDefaultPrompt();
        }

        public void printInfo() throws IOException {
            this.shell.printInfo();
        }

        public boolean isMasking() {
            return this.shell.isMasking();
        }

        public synchronized boolean isWaitingForInput() {
            return this.readWait;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    private static class StringBuilderOutputStream
    extends OutputStream {
        StringBuilder sb = new StringBuilder();

        private StringBuilderOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.sb.append((char)(0xFF & b));
        }

        public String get() {
            return this.sb.toString();
        }

        public void clear() {
            this.sb.setLength(0);
        }
    }
}

