/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.util.Map;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.SetupPermissions;
import org.apache.accumulo.server.master.tableOps.TableInfo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.tabletserver.TabletTime;

public class CreateTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo = new TableInfo();

    public CreateTable(String user, String tableName, TimeType timeType, Map<String, String> props) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.timeType = TabletTime.getTimeID(timeType);
        this.tableInfo.user = user;
        this.tableInfo.props = props;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.idLock.lock();
        try {
            this.tableInfo.tableId = Utils.getNextTableId(this.tableInfo.tableName, master.getInstance());
            SetupPermissions setupPermissions = new SetupPermissions(this.tableInfo);
            return setupPermissions;
        }
        finally {
            Utils.idLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
    }
}

