/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.AddressUtil;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class LiveTServerSet
implements Watcher {
    private static final Logger log = Logger.getLogger(LiveTServerSet.class);
    private final Listener cback;
    private final Instance instance;
    private final AccumuloConfiguration conf;
    private ZooCache zooCache;
    private Map<String, TServerInfo> current = new HashMap<String, TServerInfo>();
    private Map<String, Long> locklessServers = new HashMap<String, Long>();

    public LiveTServerSet(Instance instance, AccumuloConfiguration conf, Listener cback) {
        this.cback = cback;
        this.instance = instance;
        this.conf = conf;
    }

    public synchronized ZooCache getZooCache() {
        if (this.zooCache == null) {
            this.zooCache = new ZooCache(this);
        }
        return this.zooCache;
    }

    public synchronized void startListeningForTabletServerChanges() {
        this.scanServers();
        SimpleTimer.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                LiveTServerSet.this.scanServers();
            }
        }, 0L, 5000L);
    }

    public synchronized void scanServers() {
        try {
            HashSet<TServerInstance> updates = new HashSet<TServerInstance>();
            HashSet<TServerInstance> doomed = new HashSet<TServerInstance>();
            String path = ZooUtil.getRoot((Instance)this.instance) + "/tservers";
            HashSet<String> all = new HashSet<String>(this.current.keySet());
            all.addAll(this.getZooCache().getChildren(path));
            this.locklessServers.keySet().retainAll(all);
            for (String server : all) {
                this.checkServer(updates, doomed, path, server);
            }
            if (!doomed.isEmpty() || !updates.isEmpty()) {
                this.cback.update(this, doomed, updates);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    private void deleteServerNode(String serverNode) throws InterruptedException, KeeperException {
        try {
            ZooReaderWriter.getInstance().delete(serverNode, -1);
        }
        catch (KeeperException.NotEmptyException ex) {
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private synchronized void checkServer(Set<TServerInstance> updates, Set<TServerInstance> doomed, String path, String server) throws TException, InterruptedException, KeeperException {
        TServerInfo info = this.current.get(server);
        String lockPath = path + "/" + server;
        Stat stat = new Stat();
        byte[] lockData = ZooLock.getLockData((org.apache.accumulo.fate.zookeeper.ZooCache)this.getZooCache(), (String)lockPath, (Stat)stat);
        if (lockData == null) {
            Long firstSeen;
            if (info != null) {
                doomed.add(info.instance);
                this.current.remove(server);
            }
            if ((firstSeen = this.locklessServers.get(server)) == null) {
                this.locklessServers.put(server, System.currentTimeMillis());
            } else if (System.currentTimeMillis() - firstSeen > 600000L) {
                this.deleteServerNode(path + "/" + server);
                this.locklessServers.remove(server);
            }
        } else {
            this.locklessServers.remove(server);
            ServerServices services = new ServerServices(new String(lockData));
            InetSocketAddress client = services.getAddress(ServerServices.Service.TSERV_CLIENT);
            InetSocketAddress addr = AddressUtil.parseAddress(server, Property.TSERV_CLIENTPORT);
            TServerInstance instance = new TServerInstance(client, stat.getEphemeralOwner());
            if (info == null) {
                updates.add(instance);
                this.current.put(server, new TServerInfo(instance, new TServerConnection(addr)));
            } else if (!info.instance.equals(instance)) {
                doomed.add(info.instance);
                updates.add(instance);
                this.current.put(server, new TServerInfo(instance, new TServerConnection(addr)));
            }
        }
    }

    public void process(WatchedEvent event) {
        if (event.getPath() != null) {
            int pos;
            if (event.getPath().endsWith("/tservers")) {
                this.scanServers();
            } else if (event.getPath().contains("/tservers") && (pos = event.getPath().lastIndexOf(47)) >= 0 && event.getPath().substring(0, pos).endsWith("/tservers")) {
                String server = event.getPath().substring(pos + 1);
                HashSet<TServerInstance> updates = new HashSet<TServerInstance>();
                HashSet<TServerInstance> doomed = new HashSet<TServerInstance>();
                String path = ZooUtil.getRoot((Instance)this.instance) + "/tservers";
                try {
                    this.checkServer(updates, doomed, path, server);
                    if (!doomed.isEmpty() || !updates.isEmpty()) {
                        this.cback.update(this, doomed, updates);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public synchronized TServerConnection getConnection(TServerInstance server) throws TException {
        if (server == null) {
            return null;
        }
        TServerInfo serverInfo = this.current.get(server.hostPort());
        if (serverInfo == null) {
            return null;
        }
        if (!serverInfo.instance.equals(server)) {
            return null;
        }
        TServerConnection result = serverInfo.connection;
        return result;
    }

    public synchronized Set<TServerInstance> getCurrentServers() {
        HashSet<TServerInstance> result = new HashSet<TServerInstance>();
        for (TServerInfo c : this.current.values()) {
            result.add(c.instance);
        }
        return result;
    }

    public synchronized int size() {
        return this.current.size();
    }

    public synchronized TServerInstance find(String serverName) {
        TServerInfo serverInfo = this.current.get(serverName);
        if (serverInfo != null) {
            return serverInfo.instance;
        }
        return null;
    }

    public synchronized boolean isOnline(String serverName) {
        return this.current.containsKey(serverName);
    }

    public synchronized void remove(TServerInstance server) {
        this.current.remove(server.hostPort());
        log.info((Object)("Removing zookeeper lock for " + server));
        String zpath = ZooUtil.getRoot((Instance)this.instance) + "/tservers" + "/" + server.hostPort();
        try {
            ZooReaderWriter.getRetryingInstance().recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception e) {
            String msg = "error removing tablet server lock";
            log.fatal((Object)msg, (Throwable)e);
            Halt.halt(msg, -1);
        }
        this.getZooCache().clear(zpath);
    }

    static class TServerInfo {
        TServerConnection connection;
        TServerInstance instance;

        TServerInfo(TServerInstance instance, TServerConnection connection) {
            this.connection = connection;
            this.instance = instance;
        }
    }

    public class TServerConnection {
        private final InetSocketAddress address;

        public TServerConnection(InetSocketAddress addr) throws TException {
            this.address = addr;
        }

        private String lockString(ZooLock mlock) {
            return mlock.getLockID().serialize(ZooUtil.getRoot((Instance)LiveTServerSet.this.instance) + "/masters/lock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assignTablet(ZooLock lock, KeyExtent extent) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.loadTablet(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), extent.toThrift());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unloadTablet(ZooLock lock, KeyExtent extent, boolean save) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.unloadTablet(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), extent.toThrift(), save);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TabletServerStatus getTableMap(boolean usePooledConnection) throws TException, ThriftSecurityException {
            if (usePooledConnection) {
                throw new UnsupportedOperationException();
            }
            TTransport transport = ThriftUtil.createTransport((InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.createClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (TTransport)transport);
                TabletServerStatus tabletServerStatus = client.getTabletServerStatus(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
                return tabletServerStatus;
            }
            finally {
                if (transport != null) {
                    transport.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void halt(ZooLock lock) throws TException, ThriftSecurityException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.halt(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fastHalt(ZooLock lock) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.fastHalt(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(ZooLock lock, String tableId, byte[] startRow, byte[] endRow) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.flush(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), tableId, startRow == null ? null : ByteBuffer.wrap(startRow), endRow == null ? null : ByteBuffer.wrap(endRow));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chop(ZooLock lock, KeyExtent extent) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.chop(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), extent.toThrift());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void splitTablet(ZooLock lock, KeyExtent extent, Text splitPoint) throws TException, ThriftSecurityException, NotServingTabletException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.splitTablet(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), extent.toThrift(), ByteBuffer.wrap(splitPoint.getBytes(), 0, splitPoint.getLength()));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushTablet(ZooLock lock, KeyExtent extent) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.flushTablet(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), extent.toThrift());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compact(ZooLock lock, String tableId, byte[] startRow, byte[] endRow) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                client.compact(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), this.lockString(lock), tableId, startRow == null ? null : ByteBuffer.wrap(startRow), endRow == null ? null : ByteBuffer.wrap(endRow));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive(long tid) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)this.address, (AccumuloConfiguration)LiveTServerSet.this.conf);
            try {
                boolean bl = client.isActive(Tracer.traceInfo(), tid);
                return bl;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }
    }

    public static interface Listener {
        public void update(LiveTServerSet var1, Set<TServerInstance> var2, Set<TServerInstance> var3);
    }
}

