/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.PigException;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.Launcher;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POBroadcastSpark;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoinSpark;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.spark.JobGraphBuilder;
import org.apache.pig.backend.hadoop.executionengine.spark.JobMetricsListener;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkEngineConf;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPOUserFuncVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.UDFJarsFinder;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.BroadcastConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.CollectedGroupConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.CounterConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.DistinctConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.FRJoinConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.FilterConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.ForEachConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.GlobalRearrangeConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.JoinGroupSparkConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.LimitConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.LoadConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.LocalRearrangeConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.MergeCogroupConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.MergeJoinConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.PackageConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.PoissonSampleConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RankConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.ReduceByConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SkewedJoinConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SortConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SparkSampleSortConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SplitConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.StoreConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.StreamConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.UnionConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POJoinGroupSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POPoissonSampleSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POReduceBySpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POSampleSortSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.AccumulatorOptimizer;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.CombinerOptimizer;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.JoinGroupOptimizerSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.MultiQueryOptimizerSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.NoopFilterRemover;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.ParallelismSetter;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.SecondaryKeyOptimizerSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.DotSparkPrinter;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkCompiler;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkPOPackageAnnotator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkPrinter;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.XMLSparkPrinter;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.SparkCounterGroup;
import org.apache.pig.tools.pigstats.spark.SparkCounters;
import org.apache.pig.tools.pigstats.spark.SparkPigStats;
import org.apache.pig.tools.pigstats.spark.SparkPigStatusReporter;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.JobLogger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.StatsReportListener;

public class SparkLauncher
extends Launcher {
    private static final Log LOG = LogFactory.getLog(SparkLauncher.class);
    private static JavaSparkContext sparkContext = null;
    private static JobMetricsListener jobMetricsListener = new JobMetricsListener();
    private String jobGroupID;
    private PigContext pigContext = null;
    private JobConf jobConf = null;
    private String currentDirectoryPath = null;
    private SparkEngineConf sparkEngineConf = new SparkEngineConf();
    private static final String PIG_WARNING_FQCN = PigWarning.class.getCanonicalName();

    @Override
    public PigStats launchPig(PhysicalPlan physicalPlan, String grpName, PigContext pigContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)physicalPlan);
        }
        this.pigContext = pigContext;
        this.initialize(physicalPlan);
        SparkOperPlan sparkplan = this.compile(physicalPlan, pigContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)sparkplan);
        }
        SparkPigStats sparkStats = (SparkPigStats)pigContext.getExecutionEngine().instantiatePigStats();
        sparkStats.initialize(pigContext, sparkplan, (Configuration)this.jobConf);
        PigStats.start(sparkStats);
        SparkLauncher.startSparkIfNeeded(pigContext);
        this.jobGroupID = String.format("%s-%s", sparkContext.getConf().getAppId(), UUID.randomUUID().toString());
        this.jobConf.set("mapred.job.id", this.jobGroupID);
        sparkContext.setJobGroup(this.jobGroupID, "Pig query to Spark cluster", false);
        jobMetricsListener.reset();
        this.currentDirectoryPath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + "/";
        new ParallelismSetter(sparkplan, this.jobConf).visit();
        SparkLauncher.prepareSparkCounters(this.jobConf);
        HashMap<Class<? extends PhysicalOperator>, RDDConverter> convertMap = new HashMap<Class<? extends PhysicalOperator>, RDDConverter>();
        convertMap.put(POLoad.class, new LoadConverter(pigContext, physicalPlan, sparkContext.sc(), this.jobConf, this.sparkEngineConf));
        convertMap.put(POStore.class, new StoreConverter(this.jobConf));
        convertMap.put(POForEach.class, new ForEachConverter(this.jobConf));
        convertMap.put(POFilter.class, new FilterConverter());
        convertMap.put(POPackage.class, new PackageConverter());
        convertMap.put(POLocalRearrange.class, new LocalRearrangeConverter());
        convertMap.put(POGlobalRearrangeSpark.class, new GlobalRearrangeConverter());
        convertMap.put(POJoinGroupSpark.class, new JoinGroupSparkConverter());
        convertMap.put(POLimit.class, new LimitConverter());
        convertMap.put(PODistinct.class, new DistinctConverter());
        convertMap.put(POUnion.class, new UnionConverter(sparkContext.sc()));
        convertMap.put(POSort.class, new SortConverter());
        convertMap.put(POSplit.class, new SplitConverter());
        convertMap.put(POSkewedJoin.class, new SkewedJoinConverter());
        convertMap.put(POMergeJoin.class, new MergeJoinConverter());
        convertMap.put(POCollectedGroup.class, new CollectedGroupConverter());
        convertMap.put(POCounter.class, new CounterConverter());
        convertMap.put(PORank.class, new RankConverter());
        convertMap.put(POStream.class, new StreamConverter());
        convertMap.put(POFRJoinSpark.class, new FRJoinConverter());
        convertMap.put(POMergeCogroup.class, new MergeCogroupConverter());
        convertMap.put(POReduceBySpark.class, new ReduceByConverter());
        convertMap.put(POPreCombinerLocalRearrange.class, new LocalRearrangeConverter());
        convertMap.put(POBroadcastSpark.class, new BroadcastConverter(sparkContext));
        convertMap.put(POSampleSortSpark.class, new SparkSampleSortConverter());
        convertMap.put(POPoissonSampleSpark.class, new PoissonSampleConverter());
        Configuration conf = ConfigurationUtil.toConfiguration(pigContext.getProperties());
        if (conf.getBoolean("pig.print.exec.plan", false)) {
            LOG.info((Object)sparkplan);
        }
        this.uploadResources(sparkplan);
        new JobGraphBuilder(sparkplan, convertMap, sparkStats, sparkContext, jobMetricsListener, this.jobGroupID, this.jobConf, pigContext).visit();
        this.cleanUpSparkJob(sparkStats);
        sparkStats.finish();
        this.resetUDFContext();
        return sparkStats;
    }

    private void resetUDFContext() {
        UDFContext.getUDFContext().addJobConf(null);
    }

    private void uploadResources(SparkOperPlan sparkPlan) throws IOException {
        this.addFilesToSparkJob(sparkPlan);
        this.addJarsToSparkJob(sparkPlan);
    }

    private void optimize(SparkOperPlan plan, PigContext pigContext) throws IOException {
        boolean isAccum;
        Configuration conf = ConfigurationUtil.toConfiguration(pigContext.getProperties());
        boolean noCombiner = conf.getBoolean("pig.exec.nocombiner", false);
        if (!pigContext.inIllustrator && !noCombiner) {
            CombinerOptimizer combinerOptimizer = new CombinerOptimizer(plan);
            combinerOptimizer.visit();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After combiner optimization:");
                LOG.debug((Object)plan);
            }
        }
        boolean noSecondaryKey = conf.getBoolean("pig.exec.nosecondarykey", false);
        if (!pigContext.inIllustrator && !noSecondaryKey) {
            SecondaryKeyOptimizerSpark skOptimizer = new SecondaryKeyOptimizerSpark(plan);
            skOptimizer.visit();
        }
        if (isAccum = conf.getBoolean("opt.accumulator", true)) {
            AccumulatorOptimizer accum = new AccumulatorOptimizer(plan);
            accum.visit();
        }
        NoopFilterRemover fRem = new NoopFilterRemover(plan);
        fRem.visit();
        boolean isMultiQuery = conf.getBoolean("opt.multiquery", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Before multiquery optimization:");
            LOG.debug((Object)plan);
        }
        if (isMultiQuery) {
            MultiQueryOptimizerSpark mqOptimizer = new MultiQueryOptimizerSpark(plan);
            mqOptimizer.visit();
        }
        JoinGroupOptimizerSpark joinOptimizer = new JoinGroupOptimizerSpark(plan);
        joinOptimizer.visit();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"After multiquery optimization:");
            LOG.debug((Object)plan);
        }
    }

    private void cleanUpSparkJob(SparkPigStats sparkStats) throws ExecException {
        boolean isLocal;
        LOG.info((Object)"Clean up Spark Job");
        boolean bl = isLocal = System.getenv("SPARK_MASTER") != null ? System.getenv("SPARK_MASTER").equalsIgnoreCase("LOCAL") : true;
        if (isLocal) {
            String cacheFiles;
            String shipFiles = this.pigContext.getProperties().getProperty("pig.streaming.ship.files");
            if (shipFiles != null) {
                for (String file : shipFiles.split(",")) {
                    File shipFile = new File(file);
                    File deleteFile = new File(this.currentDirectoryPath + "/" + shipFile.getName());
                    if (!deleteFile.exists()) continue;
                    LOG.info((Object)String.format("Delete ship file result: %b", deleteFile.delete()));
                }
            }
            if ((cacheFiles = this.pigContext.getProperties().getProperty("pig.streaming.cache.files")) != null) {
                for (String file : cacheFiles.split(",")) {
                    String fileName = this.extractFileName(file.trim());
                    File deleteFile = new File(this.currentDirectoryPath + "/" + fileName);
                    if (!deleteFile.exists()) continue;
                    LOG.info((Object)String.format("Delete cache file result: %b", deleteFile.delete()));
                }
            }
        }
        for (OutputStats output : sparkStats.getOutputStats()) {
            POStore store = output.getPOStore();
            try {
                if (!output.isSuccessful()) {
                    store.getStoreFunc().cleanupOnFailure(store.getSFile().getFileName(), Job.getInstance((Configuration)output.getConf()));
                    continue;
                }
                store.getStoreFunc().cleanupOnSuccess(store.getSFile().getFileName(), Job.getInstance((Configuration)output.getConf()));
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
        }
    }

    private void addFilesToSparkJob(SparkOperPlan sparkPlan) throws IOException {
        LOG.info((Object)"Add files Spark Job");
        String shipFiles = this.pigContext.getProperties().getProperty("pig.streaming.ship.files");
        this.shipFiles(shipFiles);
        String cacheFiles = this.pigContext.getProperties().getProperty("pig.streaming.cache.files");
        this.cacheFiles(cacheFiles);
        this.addUdfResourcesToSparkJob(sparkPlan);
    }

    private void addUdfResourcesToSparkJob(SparkOperPlan sparkPlan) throws IOException {
        SparkPOUserFuncVisitor sparkPOUserFuncVisitor = new SparkPOUserFuncVisitor(sparkPlan);
        sparkPOUserFuncVisitor.visit();
        Joiner joiner = Joiner.on((String)",");
        String shipFiles = joiner.join(sparkPOUserFuncVisitor.getShipFiles());
        this.shipFiles(shipFiles);
        String cacheFiles = joiner.join(sparkPOUserFuncVisitor.getCacheFiles());
        this.cacheFiles(cacheFiles);
    }

    private void shipFiles(String shipFiles) throws IOException {
        if (shipFiles != null && !shipFiles.isEmpty()) {
            for (String file : shipFiles.split(",")) {
                File shipFile = new File(file.trim());
                if (!shipFile.exists()) continue;
                this.addResourceToSparkJobWorkingDirectory(shipFile, shipFile.getName(), shipFile.getName().endsWith(".jar") ? ResourceType.JAR : ResourceType.FILE);
            }
        }
    }

    private void cacheFiles(String cacheFiles) throws IOException {
        if (cacheFiles != null && !cacheFiles.isEmpty()) {
            File tmpFolder = Files.createTempDirectory("cache", new FileAttribute[0]).toFile();
            tmpFolder.deleteOnExit();
            for (String file : cacheFiles.split(",")) {
                String fileUrl;
                String fileName = this.extractFileName(file.trim());
                if (fileName == null || (fileUrl = this.extractFileUrl(file.trim())) == null) continue;
                Path src = new Path(fileUrl);
                File tmpFile = new File(tmpFolder, fileName);
                Path tmpFilePath = new Path(tmpFile.getAbsolutePath());
                FileSystem fs = tmpFilePath.getFileSystem((Configuration)this.jobConf);
                fs.copyToLocalFile(src, tmpFilePath);
                tmpFile.deleteOnExit();
                LOG.info((Object)String.format("CacheFile:%s", fileName));
                this.addResourceToSparkJobWorkingDirectory(tmpFile, fileName, ResourceType.FILE);
            }
        }
    }

    private void addJarsToSparkJob(SparkOperPlan sparkPlan) throws IOException {
        HashSet<String> allJars = new HashSet<String>();
        LOG.info((Object)"Add default jars to Spark Job");
        allJars.addAll(JarManager.getDefaultJars());
        LOG.info((Object)"Add script jars to Spark Job");
        for (String scriptJar : this.pigContext.scriptJars) {
            allJars.add(scriptJar);
        }
        LOG.info((Object)"Add udf jars to Spark Job");
        UDFJarsFinder udfJarsFinder = new UDFJarsFinder(sparkPlan, this.pigContext);
        udfJarsFinder.visit();
        Set<String> udfJars = udfJarsFinder.getUdfJars();
        for (String udfJar : udfJars) {
            allJars.add(udfJar);
        }
        File scriptUDFJarFile = JarManager.createPigScriptUDFJar(this.pigContext);
        if (scriptUDFJarFile != null) {
            LOG.info((Object)"Add script udf jar to Spark job");
            allJars.add(scriptUDFJarFile.getAbsolutePath().toString());
        }
        LOG.info((Object)"Add extra jars to Spark job");
        for (URL extraJarUrl : this.pigContext.extraJars) {
            allJars.add(extraJarUrl.getFile());
        }
        for (String jar : allJars) {
            File jarFile = new File(jar);
            this.addResourceToSparkJobWorkingDirectory(jarFile, jarFile.getName(), ResourceType.JAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceToSparkJobWorkingDirectory(File resourcePath, String resourceName, ResourceType resourceType) throws IOException {
        boolean isLocal;
        if (resourceType == ResourceType.JAR) {
            LOG.info((Object)("Added jar " + resourceName));
        } else {
            LOG.info((Object)("Added file " + resourceName));
        }
        boolean bl = isLocal = System.getenv("SPARK_MASTER") != null ? System.getenv("SPARK_MASTER").equalsIgnoreCase("LOCAL") : true;
        if (isLocal) {
            File localFile = new File(this.currentDirectoryPath + "/" + resourceName);
            if (resourcePath.getAbsolutePath().equals(localFile.getAbsolutePath()) && resourcePath.exists()) {
                return;
            }
            Class<SparkLauncher> clazz = SparkLauncher.class;
            synchronized (SparkLauncher.class) {
                if (localFile.exists()) {
                    LOG.info((Object)String.format("Jar file %s exists, ready to delete", localFile.getAbsolutePath()));
                    localFile.delete();
                } else {
                    LOG.info((Object)String.format("Jar file %s not exists,", localFile.getAbsolutePath()));
                }
                Files.copy(Paths.get(new Path(resourcePath.getAbsolutePath()).toString(), new String[0]), Paths.get(localFile.getAbsolutePath(), new String[0]), new CopyOption[0]);
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        } else if (resourceType == ResourceType.JAR) {
            sparkContext.addJar(resourcePath.toURI().toURL().toExternalForm());
        } else if (resourceType == ResourceType.FILE) {
            sparkContext.addFile(resourcePath.toURI().toURL().toExternalForm());
        }
    }

    private String extractFileName(String cacheFileUrl) {
        String[] tmpAry = cacheFileUrl.split("#");
        String fileName = tmpAry != null && tmpAry.length == 2 ? tmpAry[1] : null;
        return fileName;
    }

    private String extractFileUrl(String cacheFileUrl) {
        String[] tmpAry = cacheFileUrl.split("#");
        String fileName = tmpAry != null && tmpAry.length == 2 ? tmpAry[0] : null;
        return fileName;
    }

    public SparkOperPlan compile(PhysicalPlan physicalPlan, PigContext pigContext) throws PlanException, IOException, VisitorException {
        SparkCompiler sparkCompiler = new SparkCompiler(physicalPlan, pigContext);
        sparkCompiler.compile();
        sparkCompiler.connectSoftLink();
        SparkOperPlan sparkPlan = sparkCompiler.getSparkPlan();
        SparkPOPackageAnnotator pkgAnnotator = new SparkPOPackageAnnotator(sparkPlan);
        pkgAnnotator.visit();
        this.optimize(sparkPlan, pigContext);
        return sparkPlan;
    }

    private static synchronized void startSparkIfNeeded(PigContext pc) throws PigException {
        if (sparkContext == null) {
            String master = null;
            if (pc.getExecType().isLocal()) {
                master = "local";
            } else {
                master = System.getenv("SPARK_MASTER");
                if (master == null) {
                    LOG.info((Object)"SPARK_MASTER not specified, using \"local\"");
                    master = "local";
                }
            }
            String sparkHome = System.getenv("SPARK_HOME");
            if (!master.startsWith("local") && !master.equals("yarn-client") && sparkHome == null) {
                System.err.println("You need to set SPARK_HOME to run on a Mesos cluster!");
                throw new PigException("SPARK_HOME is not set");
            }
            SparkConf sparkConf = new SparkConf();
            Properties pigCtxtProperties = pc.getProperties();
            sparkConf.setMaster(master);
            sparkConf.setAppName(pigCtxtProperties.getProperty("jobName", "pig"));
            String useNettyFileServer = pigCtxtProperties.getProperty("pig.spark.rpc.useNettyFileServer", "false");
            sparkConf.set("spark.rpc.useNettyFileServer", useNettyFileServer);
            if (sparkHome != null && !sparkHome.isEmpty()) {
                sparkConf.setSparkHome(sparkHome);
            } else {
                LOG.warn((Object)"SPARK_HOME is not set");
            }
            for (String key : pigCtxtProperties.stringPropertyNames()) {
                if (!key.startsWith("spark.")) continue;
                LOG.debug((Object)("Copying key " + key + " with value " + pigCtxtProperties.getProperty(key) + " to SparkConf"));
                sparkConf.set(key, pigCtxtProperties.getProperty(key));
            }
            sparkConf.set("spark.executor.userClassPathFirst", "true");
            SparkLauncher.checkAndConfigureDynamicAllocation(master, sparkConf);
            sparkContext = new JavaSparkContext(sparkConf);
            sparkContext.sc().addSparkListener((SparkListener)new StatsReportListener());
            sparkContext.sc().addSparkListener((SparkListener)new JobLogger());
            sparkContext.sc().addSparkListener((SparkListener)jobMetricsListener);
        }
    }

    private static void checkAndConfigureDynamicAllocation(String master, SparkConf sparkConf) {
        if (sparkConf.getBoolean("spark.dynamicAllocation.enabled", false)) {
            if (!master.startsWith("yarn")) {
                LOG.warn((Object)"Dynamic allocation is enabled, but script isn't running on yarn. Ignoring ...");
            }
            if (!sparkConf.getBoolean("spark.shuffle.service.enabled", false)) {
                LOG.info((Object)"Spark shuffle service is being enabled as dynamic allocation is enabled");
                sparkConf.set("spark.shuffle.service.enabled", "true");
            }
        }
    }

    static void stopSpark() {
        if (sparkContext != null) {
            sparkContext.stop();
            sparkContext = null;
        }
    }

    @Override
    public void explain(PhysicalPlan pp, PigContext pc, PrintStream ps, String format, boolean verbose) throws IOException {
        SparkOperPlan sparkPlan = this.compile(pp, pc);
        this.explain(sparkPlan, ps, format, verbose);
    }

    private void explain(SparkOperPlan sparkPlan, PrintStream ps, String format, boolean verbose) throws IOException {
        Map allOperKeys = sparkPlan.getKeys();
        ArrayList<OperatorKey> operKeyList = new ArrayList<OperatorKey>(allOperKeys.keySet());
        Collections.sort(operKeyList);
        if (format.equals("text")) {
            for (OperatorKey operatorKey : operKeyList) {
                SparkOperator op = (SparkOperator)sparkPlan.getOperator(operatorKey);
                ps.print(op.getOperatorKey());
                List<SparkOperator> successors = sparkPlan.getSuccessors(op);
                if (successors != null) {
                    ps.print("->");
                    for (SparkOperator suc : successors) {
                        ps.print(suc.getOperatorKey() + " ");
                    }
                }
                ps.println();
            }
            SparkPrinter printer = new SparkPrinter(ps, sparkPlan);
            printer.setVerbose(verbose);
            printer.visit();
        } else if (format.equals("dot")) {
            ps.println("#--------------------------------------------------");
            ps.println("# Spark Plan");
            ps.println("#--------------------------------------------------");
            DotSparkPrinter printer = new DotSparkPrinter(sparkPlan, ps);
            printer.setVerbose(verbose);
            printer.dump();
            ps.println("");
        } else if (format.equals("xml")) {
            try {
                XMLSparkPrinter printer = new XMLSparkPrinter(ps, sparkPlan);
                printer.visit();
                printer.closePlan();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        } else {
            throw new IOException("Unsupported explain format. Supported formats are: text, dot, xml");
        }
    }

    @Override
    public void kill() throws BackendException {
        if (sparkContext != null) {
            sparkContext.stop();
            sparkContext = null;
        }
    }

    @Override
    public void killJob(String jobID, Configuration conf) throws BackendException {
        if (sparkContext != null) {
            sparkContext.stop();
            sparkContext = null;
        }
    }

    private void saveUdfImportList() {
        String udfImportList = Joiner.on((String)",").join(PigContext.getPackageImportList());
        this.sparkEngineConf.setSparkUdfImportListStr(udfImportList);
    }

    private void initialize(PhysicalPlan physicalPlan) throws IOException {
        this.saveUdfImportList();
        this.jobConf = SparkUtil.newJobConf(this.pigContext, physicalPlan, this.sparkEngineConf);
        SchemaTupleBackend.initialize((Configuration)this.jobConf, this.pigContext);
        Utils.setDefaultTimeZone((Configuration)this.jobConf);
        PigMapReduce.sJobConfInternal.set(this.jobConf);
        String parallelism = this.pigContext.getProperties().getProperty("spark.default.parallelism");
        if (parallelism != null) {
            SparkPigContext.get();
            SparkPigContext.setDefaultParallelism(Integer.parseInt(parallelism));
        }
    }

    private static void prepareSparkCounters(JobConf jobConf) throws IOException {
        SparkPigStatusReporter statusReporter = SparkPigStatusReporter.getInstance();
        SparkCounters counters = new SparkCounters(sparkContext);
        if ("true".equalsIgnoreCase(jobConf.get("aggregate.warning"))) {
            SparkCounterGroup.MapSparkCounterGroup pigWarningGroup = new SparkCounterGroup.MapSparkCounterGroup(PIG_WARNING_FQCN, PIG_WARNING_FQCN, sparkContext);
            ((SparkCounterGroup)pigWarningGroup).createCounter(PigWarning.SPARK_WARN.name(), new HashMap());
            ((SparkCounterGroup)pigWarningGroup).createCounter(PigWarning.SPARK_CUSTOM_WARN.name(), new HashMap());
            counters.getSparkCounterGroups().put(PIG_WARNING_FQCN, pigWarningGroup);
        }
        statusReporter.setCounters(counters);
        jobConf.set("pig.spark.counters", ObjectSerializer.serialize(counters));
    }

    public static enum ResourceType {
        JAR,
        FILE;

    }
}

