/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractCSQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(AbstractCSQueue.class);
    CSQueue parent;
    final String queueName;
    volatile int numContainers;
    final Resource minimumAllocation;
    Resource maximumAllocation;
    QueueState state;
    final QueueMetrics metrics;
    protected final PrivilegedEntity queueEntity;
    final ResourceCalculator resourceCalculator;
    Set<String> accessibleLabels;
    RMNodeLabelsManager labelManager;
    String defaultLabelExpression;
    Map<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
    boolean reservationsContinueLooking;
    private boolean preemptionDisabled;
    ResourceUsage queueUsage;
    QueueCapacities queueCapacities;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected CapacitySchedulerContext csContext;
    protected YarnAuthorizationProvider authorizer = null;
    private Resource clusterResource;

    public AbstractCSQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this.labelManager = cs.getRMContext().getNodeLabelManager();
        this.parent = parent;
        this.queueName = queueName;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.csContext = cs;
        this.minimumAllocation = this.csContext.getMinimumResourceCapability();
        this.queueUsage = new ResourceUsage();
        this.queueEntity = new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, this.getQueuePath());
        this.queueCapacities = new QueueCapacities(parent == null);
    }

    protected void setupConfigurableCapacities() {
        CSQueueUtils.loadUpdateAndCheckCapacities(this.getQueuePath(), this.csContext.getConfiguration(), this.queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }

    @Override
    public synchronized float getCapacity() {
        return this.queueCapacities.getCapacity();
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.queueCapacities.getAbsoluteCapacity();
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.queueCapacities.getAbsoluteMaximumCapacity();
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.queueCapacities.getAbsoluteUsedCapacity();
    }

    @Override
    public float getMaximumCapacity() {
        return this.queueCapacities.getMaximumCapacity();
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.queueCapacities.getUsedCapacity();
    }

    @Override
    public Resource getUsedResources() {
        return this.queueUsage.getUsed();
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    public PrivilegedEntity getPrivilegedEntity() {
        return this.queueEntity;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.authorizer.checkPermission(SchedulerUtils.toAccessType(acl), this.queueEntity, user);
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.queueCapacities.setUsedCapacity(usedCapacity);
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.queueCapacities.setAbsoluteUsedCapacity(absUsedCapacity);
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.queueCapacities.getCapacity(), maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
        CSQueueUtils.checkAbsoluteCapacity(this.getQueueName(), this.queueCapacities.getAbsoluteCapacity(), absMaxCapacity);
        this.queueCapacities.setMaximumCapacity(maximumCapacity);
        this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.defaultLabelExpression;
    }

    synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.accessibleLabels = this.csContext.getConfiguration().getAccessibleNodeLabels(this.getQueuePath());
        this.defaultLabelExpression = this.csContext.getConfiguration().getDefaultNodeLabelExpression(this.getQueuePath());
        if (this.accessibleLabels == null && this.parent != null) {
            this.accessibleLabels = this.parent.getAccessibleNodeLabels();
        }
        if (this.defaultLabelExpression == null && this.parent != null && this.accessibleLabels.containsAll(this.parent.getAccessibleNodeLabels())) {
            this.defaultLabelExpression = this.parent.getDefaultNodeLabelExpression();
        }
        this.setupConfigurableCapacities();
        this.maximumAllocation = this.csContext.getConfiguration().getMaximumAllocationPerQueue(this.getQueuePath());
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.csContext.getConf());
        this.state = this.csContext.getConfiguration().getState(this.getQueuePath());
        this.acls = this.csContext.getConfiguration().getAcls(this.getQueuePath());
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        if (this.parent != null && this.parent.getParent() != null && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
            if (this.getAccessibleNodeLabels().contains("*")) {
                throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
            }
            Sets.SetView diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
            if (!diff.isEmpty()) {
                throw new IOException("Some labels of child queue is not a subset of parent queue, these labels=[" + StringUtils.join((Collection)diff, (String)",") + "]");
            }
        }
        this.reservationsContinueLooking = this.csContext.getConfiguration().getReservationContinueLook();
        this.preemptionDisabled = this.isQueueHierarchyPreemptionDisabled(this);
        this.clusterResource = clusterResource;
    }

    protected QueueInfo getQueueInfo() {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.queueName);
        queueInfo.setAccessibleNodeLabels(this.accessibleLabels);
        queueInfo.setCapacity(this.queueCapacities.getCapacity());
        queueInfo.setMaximumCapacity(this.queueCapacities.getMaximumCapacity());
        queueInfo.setQueueState(this.state);
        queueInfo.setDefaultNodeLabelExpression(this.defaultLabelExpression);
        queueInfo.setCurrentCapacity(this.getUsedCapacity());
        return queueInfo;
    }

    @InterfaceAudience.Private
    public synchronized Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            this.queueUsage.incUsed(resource);
        } else {
            Set anls = this.accessibleLabels.contains("*") ? this.labelManager.getClusterNodeLabels() : this.accessibleLabels;
            for (String label : Sets.intersection((Set)anls, nodeLabels)) {
                this.queueUsage.incUsed(label, resource);
            }
        }
        ++this.numContainers;
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
    }

    protected synchronized void releaseResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        if (null == nodeLabels || nodeLabels.isEmpty()) {
            this.queueUsage.decUsed(resource);
        } else {
            Set anls = this.accessibleLabels.contains("*") ? this.labelManager.getClusterNodeLabels() : this.accessibleLabels;
            for (String label : Sets.intersection((Set)anls, nodeLabels)) {
                this.queueUsage.decUsed(label, resource);
            }
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        --this.numContainers;
    }

    @InterfaceAudience.Private
    public boolean getReservationContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<AccessType, AccessControlList> getACLs() {
        return this.acls;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getPreemptionDisabled() {
        return this.preemptionDisabled;
    }

    @Override
    @InterfaceAudience.Private
    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    @Override
    @InterfaceAudience.Private
    public ResourceUsage getQueueResourceUsage() {
        return this.queueUsage;
    }

    private boolean isQueueHierarchyPreemptionDisabled(CSQueue q) {
        CapacitySchedulerConfiguration csConf = this.csContext.getConfiguration();
        boolean systemWidePreemption = csConf.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        CSQueue parentQ = q.getParent();
        if (!systemWidePreemption) {
            return true;
        }
        if (parentQ == null) {
            return csConf.getPreemptionDisabled(q.getQueuePath(), false);
        }
        return csConf.getPreemptionDisabled(q.getQueuePath(), parentQ.getPreemptionDisabled());
    }

    private Resource getCurrentLimitResource(String nodeLabel, Resource clusterResource, ResourceLimits currentResourceLimits) {
        Resource queueMaxResource = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodeLabel, clusterResource), (double)this.queueCapacities.getAbsoluteMaximumCapacity(nodeLabel), (Resource)this.minimumAllocation);
        if (nodeLabel.equals("")) {
            return Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit());
        }
        return queueMaxResource;
    }

    synchronized boolean canAssignToThisQueue(Resource clusterResource, Set<String> nodeLabels, ResourceLimits currentResourceLimits, Resource nowRequired, Resource resourceCouldBeUnreserved) {
        HashSet<String> labelCanAccess;
        if (null == nodeLabels || nodeLabels.isEmpty()) {
            labelCanAccess = new HashSet<String>();
            labelCanAccess.add("");
        } else {
            labelCanAccess = new HashSet<String>((Collection<String>)(this.accessibleLabels.contains("*") ? nodeLabels : Sets.intersection(this.accessibleLabels, nodeLabels)));
        }
        Iterator iterator = labelCanAccess.iterator();
        if (iterator.hasNext()) {
            Resource currentLimitResource;
            String label = (String)iterator.next();
            Resource newTotalResource = Resources.add((Resource)this.queueUsage.getUsed(label), (Resource)nowRequired);
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)newTotalResource, (Resource)(currentLimitResource = this.getCurrentLimitResource(label, clusterResource, currentResourceLimits)))) {
                Resource newTotalWithoutReservedResource;
                if (this.reservationsContinueLooking && label.equals("") && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)resourceCouldBeUnreserved, (Resource)Resources.none()) && Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(newTotalWithoutReservedResource = Resources.subtract((Resource)newTotalResource, (Resource)resourceCouldBeUnreserved)), (Resource)currentLimitResource)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("try to use reserved: " + this.getQueueName() + " usedResources: " + this.queueUsage.getUsed() + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", capacity-without-reserved: " + newTotalWithoutReservedResource + ", maxLimitCapacity: " + currentLimitResource));
                    }
                    currentResourceLimits.setAmountNeededUnreserve(Resources.subtract((Resource)newTotalResource, (Resource)currentLimitResource));
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getQueueName() + "Check assign to queue, label=" + label + " usedResources: " + this.queueUsage.getUsed(label) + " clusterResources: " + clusterResource + " currentUsedCapacity " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(label), (Resource)this.labelManager.getResourceByLabel(label, clusterResource)) + " max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity(label) + ")"));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean accessibleToPartition(String nodePartition) {
        if (this.accessibleLabels != null && this.accessibleLabels.contains("*")) {
            return true;
        }
        if (nodePartition == null || nodePartition.equals("")) {
            return true;
        }
        return this.accessibleLabels != null && this.accessibleLabels.contains(nodePartition);
    }

    @Override
    public final synchronized float getUsedCapacity(String nodeLabel) {
        Resource availableToQueue = Resources.multiply((Resource)this.labelManager.getResourceByLabel(nodeLabel, this.clusterResource), (double)this.queueCapacities.getAbsoluteCapacity(nodeLabel));
        if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)availableToQueue, (Resource)Resources.none())) {
            return 0.0f;
        }
        return Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)this.queueUsage.getUsed(nodeLabel), (Resource)availableToQueue);
    }

    @Override
    public final synchronized float getAbsoluteUsedCapacity(String nodeLabel) {
        Resource labeledResources = this.labelManager.getResourceByLabel(nodeLabel, this.clusterResource);
        if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)labeledResources, (Resource)Resources.none())) {
            return 0.0f;
        }
        return Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)this.queueUsage.getUsed(nodeLabel), (Resource)labeledResources);
    }
}

