/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileReadTool
implements Tool {
    @Override
    public String getName() {
        return "tojson";
    }

    @Override
    public String getShortDescription() {
        return "Dumps an Avro data file as JSON, one record per line.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() != 1) {
            err.println("Expected 1 argument: input_file.");
            return 1;
        }
        GenericDatumReader reader = new GenericDatumReader();
        FileReader fileReader = DataFileReader.openReader((SeekableInput)Util.openSeekableFromFS(args.get(0)), (DatumReader)reader);
        try {
            Schema schema = fileReader.getSchema();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
            for (Object datum : fileReader) {
                writer.write(datum, (Encoder)encoder);
            }
            encoder.flush();
            out.println();
            out.flush();
        }
        finally {
            fileReader.close();
        }
        return 0;
    }
}

