/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGScheduler;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdateTAAssigned;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGSchedulerNaturalOrder
implements DAGScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(DAGSchedulerNaturalOrder.class);
    private final DAG dag;
    private final EventHandler handler;

    public DAGSchedulerNaturalOrder(DAG dag, EventHandler dispatcher) {
        this.dag = dag;
        this.handler = dispatcher;
    }

    @Override
    public void vertexCompleted(Vertex vertex) {
    }

    @Override
    public void scheduleTask(DAGEventSchedulerUpdate event) {
        TaskAttempt attempt = event.getAttempt();
        Vertex vertex = this.dag.getVertex(attempt.getVertexID());
        int vertexDistanceFromRoot = vertex.getDistanceFromRoot();
        int priorityLowLimit = (vertexDistanceFromRoot + 1) * 3;
        int priorityHighLimit = priorityLowLimit - 2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling " + attempt.getID() + " between priorityLow: " + priorityLowLimit + " and priorityHigh: " + priorityHighLimit);
        }
        TaskAttemptEventSchedule attemptEvent = new TaskAttemptEventSchedule(attempt.getID(), priorityLowLimit, priorityHighLimit);
        this.sendEvent(attemptEvent);
    }

    @Override
    public void taskScheduled(DAGEventSchedulerUpdateTAAssigned event) {
    }

    @Override
    public void taskSucceeded(DAGEventSchedulerUpdate event) {
    }

    void sendEvent(TaskAttemptEventSchedule event) {
        this.handler.handle((Event)event);
    }
}

