/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config.dialplan;

import java.util.ArrayList;
import org.asteriskjava.config.ConfigElement;
import org.asteriskjava.config.ConfigFileReader;
import org.asteriskjava.config.ConfigParseException;
import org.asteriskjava.config.ConfigVariable;
import org.asteriskjava.config.dialplan.ConfigExtension;
import org.asteriskjava.config.dialplan.ConfigInclude;
import org.asteriskjava.config.dialplan.ExtensionsConfigFile;

public class ExtensionsConfigFileReader
extends ConfigFileReader {
    @Override
    protected ConfigElement processTextLine(String configfile, int lineno, String line) throws ConfigParseException {
        if ((line.trim().startsWith("exten") || line.trim().startsWith("include")) && this.currentCategory != null && (this.currentCategory.getName().equals("general") || this.currentCategory.getName().equals("globals"))) {
            throw new ConfigParseException(configfile, lineno, "cannot have 'exten' or 'include' in global or general sections");
        }
        if (line.trim().startsWith("exten")) {
            ConfigExtension configElement = this.parseExtension(configfile, lineno, line);
            this.currentCategory.addElement(configElement);
            return configElement;
        }
        if (line.trim().startsWith("include")) {
            ConfigVariable configvar = this.parseVariable(configfile, lineno, line);
            ConfigInclude configElement = new ConfigInclude(configfile, lineno, configvar.getValue());
            this.currentCategory.addElement(configElement);
            return configElement;
        }
        ConfigElement configElement = super.processTextLine(configfile, lineno, line);
        return configElement;
    }

    protected ConfigExtension parseExtension(String configfile, int lineno, String line) throws ConfigParseException {
        ConfigVariable initialVariable = this.parseVariable(configfile, lineno, line);
        if (!initialVariable.getName().equals("exten")) {
            throw new ConfigParseException(configfile, lineno, "missing 'exten' near " + line);
        }
        line = initialVariable.getValue().trim();
        int nameIndex = line.indexOf(",", 0);
        if (nameIndex == -1) {
            throw new ConfigParseException(configfile, lineno, "missing extension name near " + line);
        }
        String name = line.substring(0, nameIndex);
        int priorityDelimiter = (line = line.substring(name.length() + 1, line.length()).trim()).indexOf(",", 0);
        if (priorityDelimiter == -1) {
            throw new ConfigParseException(configfile, lineno, "missing extension priority near " + line);
        }
        String priority = line.substring(0, priorityDelimiter);
        line = line.substring(priority.length() + 1, line.length()).trim();
        String[] application = ExtensionsConfigFileReader.harvestApplicationWithArguments(line);
        return new ConfigExtension(configfile, lineno, name, priority, application);
    }

    private static String[] harvestApplicationWithArguments(String arg) {
        ArrayList<String> args = new ArrayList<String>();
        if (arg.trim().length() >= 0) {
            int i;
            String[] split;
            String appl = "";
            String data = "";
            int firstc = arg.indexOf(44);
            int firstp = arg.indexOf(40);
            if (firstc != -1 && (firstp == -1 || firstc < firstp)) {
                split = arg.split(",");
                appl = split[0];
                for (i = 1; i < split.length; ++i) {
                    data = data + split[i] + (i + 1 < split.length ? "," : "");
                }
            } else if (firstc == -1 && firstp == -1) {
                data = "";
            } else {
                split = arg.split("\\(");
                appl = split[0];
                for (i = 1; i < split.length; ++i) {
                    data = data + split[i] + (i + 1 < split.length ? "(" : "");
                }
                int end = data.lastIndexOf(41);
                if (end != -1 && end == data.length() - 1) {
                    data = data.substring(0, end);
                }
                data = ExtensionsConfigFileReader.processQuotesAndSlashes(data, ',', '|');
            }
            if (!appl.trim().equals("")) {
                args.add(appl.trim());
                if (!data.trim().equals("")) {
                    String[] dataSplit;
                    for (String aDataSplit : dataSplit = data.split("\\|")) {
                        args.add(aDataSplit.trim());
                    }
                }
            }
        }
        return args.toArray(new String[args.size()]);
    }

    public ExtensionsConfigFile readExtensionsFile(String configfile) {
        super.readFile(configfile);
        return new ExtensionsConfigFile(configfile, this.categories);
    }

    private static String processQuotesAndSlashes(String start, char find, char replace_with) {
        char[] startChars;
        String dataPut = "";
        boolean inEscape = false;
        int inQuotes = 0;
        for (char startChar : startChars = start.toCharArray()) {
            if (inEscape) {
                dataPut = dataPut + startChar;
                inEscape = false;
                continue;
            }
            if (startChar == '\\') {
                inEscape = true;
                continue;
            }
            if (startChar == '\'') {
                inQuotes = 1 - inQuotes;
                continue;
            }
            dataPut = dataPut + (inQuotes != 0 ? startChar : (startChar == find ? replace_with : startChar));
        }
        return dataPut;
    }
}

