/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.activation;

import jakarta.activation.MailcapRegistry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.angus.activation.LogSupport;
import org.eclipse.angus.activation.MailcapParseException;
import org.eclipse.angus.activation.MailcapTokenizer;

public class MailcapFile
implements MailcapRegistry {
    private Map<String, Map<String, List<String>>> type_hash = new HashMap<String, Map<String, List<String>>>();
    private Map<String, Map<String, List<String>>> fallback_hash = new HashMap<String, Map<String, List<String>>>();
    private Map<String, List<String>> native_commands = new HashMap<String, List<String>>();
    private static boolean addReverse = false;

    public MailcapFile(String new_fname) throws IOException {
        LogSupport.log("new MailcapFile: file " + new_fname);
        try (BufferedReader reader = new BufferedReader(new FileReader(new_fname));){
            this.parse(reader);
        }
    }

    public MailcapFile(InputStream is) throws IOException {
        LogSupport.log("new MailcapFile: InputStream");
        this.parse(new BufferedReader(new InputStreamReader(is, StandardCharsets.ISO_8859_1)));
    }

    public MailcapFile() {
        LogSupport.log("new MailcapFile: default");
    }

    public Map<String, List<String>> getMailcapList(String mime_type) {
        return this.getMailcapList(mime_type, this.type_hash);
    }

    public Map<String, List<String>> getMailcapFallbackList(String mime_type) {
        return this.getMailcapList(mime_type, this.fallback_hash);
    }

    private Map<String, List<String>> getMailcapList(String mime_type, Map<String, Map<String, List<String>>> db) {
        String type;
        Map<String, List<String>> search_result = null;
        Map<String, List<String>> wildcard_result = null;
        search_result = db.get(mime_type);
        int separator = mime_type.indexOf(47);
        String subtype = mime_type.substring(separator + 1);
        if (!subtype.equals("*") && (wildcard_result = db.get(type = mime_type.substring(0, separator + 1) + "*")) != null) {
            search_result = search_result != null ? this.mergeResults(search_result, wildcard_result) : wildcard_result;
        }
        return search_result;
    }

    public String[] getMimeTypes() {
        HashSet<String> types = new HashSet<String>(this.type_hash.keySet());
        types.addAll(this.fallback_hash.keySet());
        types.addAll(this.native_commands.keySet());
        String[] mts = new String[types.size()];
        mts = types.toArray(mts);
        return mts;
    }

    public String[] getNativeCommands(String mime_type) {
        String[] cmds = null;
        List<String> v = this.native_commands.get(mime_type.toLowerCase(Locale.ENGLISH));
        if (v != null) {
            cmds = new String[v.size()];
            cmds = v.toArray(cmds);
        }
        return cmds;
    }

    private Map<String, List<String>> mergeResults(Map<String, List<String>> first, Map<String, List<String>> second) {
        Iterator<String> verb_enum = second.keySet().iterator();
        HashMap<String, List<String>> clonedHash = new HashMap<String, List<String>>(first);
        while (verb_enum.hasNext()) {
            String verb = verb_enum.next();
            ArrayList<String> cmdVector = (ArrayList<String>)clonedHash.get(verb);
            if (cmdVector == null) {
                clonedHash.put(verb, second.get(verb));
                continue;
            }
            List<String> oldV = second.get(verb);
            cmdVector = new ArrayList<String>(cmdVector);
            cmdVector.addAll(oldV);
            clonedHash.put(verb, cmdVector);
        }
        return clonedHash;
    }

    public void appendToMailcap(String mail_cap) {
        LogSupport.log("appendToMailcap: " + mail_cap);
        try {
            this.parse(new BufferedReader(new StringReader(mail_cap)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parse(BufferedReader reader) throws IOException {
        String line = null;
        String continued = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            try {
                if (line.charAt(0) == '#') continue;
                if (line.charAt(line.length() - 1) == '\\') {
                    if (continued != null) {
                        continued = continued + line.substring(0, line.length() - 1);
                        continue;
                    }
                    continued = line.substring(0, line.length() - 1);
                    continue;
                }
                if (continued != null) {
                    continued = continued + line;
                    try {
                        this.parseLine(continued);
                    }
                    catch (MailcapParseException mailcapParseException) {
                        // empty catch block
                    }
                    continued = null;
                    continue;
                }
                try {
                    this.parseLine(line);
                }
                catch (MailcapParseException mailcapParseException) {
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    protected void parseLine(String mailcapEntry) throws MailcapParseException, IOException {
        System.out.println("Mailcap Entry: " + mailcapEntry);
        MailcapTokenizer tokenizer = new MailcapTokenizer(mailcapEntry);
        tokenizer.setIsAutoquoting(false);
        LogSupport.log("parse: " + mailcapEntry);
        int currentToken = tokenizer.nextToken();
        if (currentToken != 2) {
            MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
        }
        String primaryType = tokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
        String subType = "*";
        currentToken = tokenizer.nextToken();
        if (currentToken != 47 && currentToken != 59) {
            MailcapFile.reportParseError(47, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
        if (currentToken == 47) {
            currentToken = tokenizer.nextToken();
            if (currentToken != 2) {
                MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
            }
            subType = tokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
            currentToken = tokenizer.nextToken();
        }
        String mimeType = primaryType + "/" + subType;
        LogSupport.log("  Type: " + mimeType);
        LinkedHashMap<String, List> commands = new LinkedHashMap<String, List>();
        if (currentToken != 59) {
            MailcapFile.reportParseError(59, currentToken, tokenizer.getCurrentTokenValue());
        }
        tokenizer.setIsAutoquoting(true);
        currentToken = tokenizer.nextToken();
        tokenizer.setIsAutoquoting(false);
        if (currentToken != 2 && currentToken != 59) {
            MailcapFile.reportParseError(2, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
        if (currentToken == 2) {
            List<String> v = this.native_commands.get(mimeType);
            if (v == null) {
                v = new ArrayList<String>();
                v.add(mailcapEntry);
                this.native_commands.put(mimeType, v);
            } else {
                v.add(mailcapEntry);
            }
            System.out.println("Mailcap Entry: native_commands = " + this.native_commands);
        }
        if (currentToken != 59) {
            currentToken = tokenizer.nextToken();
        }
        if (currentToken == 59) {
            boolean isFallback = false;
            do {
                if ((currentToken = tokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
                }
                String paramName = tokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
                currentToken = tokenizer.nextToken();
                if (currentToken != 61 && currentToken != 59 && currentToken != 5) {
                    MailcapFile.reportParseError(61, 59, 5, currentToken, tokenizer.getCurrentTokenValue());
                }
                if (currentToken != 61) continue;
                tokenizer.setIsAutoquoting(true);
                currentToken = tokenizer.nextToken();
                tokenizer.setIsAutoquoting(false);
                if (currentToken != 2) {
                    MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
                }
                String paramValue = tokenizer.getCurrentTokenValue();
                if (paramName.startsWith("x-java-")) {
                    String commandName = paramName.substring(7);
                    if (commandName.equals("fallback-entry") && paramValue.equalsIgnoreCase("true")) {
                        isFallback = true;
                    } else {
                        LogSupport.log("    Command: " + commandName + ", Class: " + paramValue);
                        List classes = commands.computeIfAbsent(commandName, k -> new ArrayList());
                        if (addReverse) {
                            classes.add(0, paramValue);
                        } else {
                            classes.add(paramValue);
                        }
                    }
                }
                currentToken = tokenizer.nextToken();
            } while (currentToken == 59);
            Map<String, Map<String, List<String>>> masterHash = isFallback ? this.fallback_hash : this.type_hash;
            Map<String, List<String>> curcommands = masterHash.get(mimeType);
            if (curcommands == null) {
                masterHash.put(mimeType, commands);
            } else {
                LogSupport.log("Merging commands for type " + mimeType);
                for (String cmdName : curcommands.keySet()) {
                    List<String> ccv = curcommands.get(cmdName);
                    List cv = (List)commands.get(cmdName);
                    if (cv == null) continue;
                    for (String clazz : cv) {
                        if (ccv.contains(clazz)) continue;
                        if (addReverse) {
                            ccv.add(0, clazz);
                            continue;
                        }
                        ccv.add(clazz);
                    }
                }
                for (String cmdName : commands.keySet()) {
                    if (curcommands.containsKey(cmdName)) continue;
                    List cv = (List)commands.get(cmdName);
                    curcommands.put(cmdName, cv);
                }
            }
            System.out.println("Mailcap Entry: fallback ? " + isFallback + "; commands = " + masterHash.get(mimeType));
        } else if (currentToken != 5) {
            MailcapFile.reportParseError(5, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
    }

    protected static void reportParseError(int expectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " token.");
    }

    protected static void reportParseError(int expectedToken, int otherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " or a " + MailcapTokenizer.nameForToken(otherExpectedToken) + " token.");
    }

    protected static void reportParseError(int expectedToken, int otherExpectedToken, int anotherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + ", a " + MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " + MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
    }

    static {
        try {
            addReverse = Boolean.getBoolean("angus.activation.addreverse");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

