/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcAndJavaMethodManager {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcAndJavaMethodManager.class);
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private Paranamer paranamer = new AnnotationParanamer();

    public void executeMethod(Method m, Object object, Transaction transaction, Request<JsonObject> request) throws IOException {
        try {
            Response<JsonElement> response = this.execJavaMethod(transaction.getSession(), object, m, transaction, request);
            if (response != null) {
                response.setId(request.getId());
                transaction.sendResponseObject(response);
            } else {
                transaction.sendVoidResponse();
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof JsonRpcErrorException) {
                JsonRpcErrorException ex = (JsonRpcErrorException)((Object)e.getCause());
                transaction.sendError(ex.getError());
            } else {
                log.error("Exception executing request " + String.valueOf(request) + ": " + e.getCause().getLocalizedMessage(), e.getCause());
                transaction.sendError(e.getCause());
            }
        }
        catch (Exception e) {
            log.error("Exception processing request " + String.valueOf(request), (Throwable)e);
            transaction.sendError(e);
        }
    }

    private Response<JsonElement> execJavaMethod(Session session, Object object, Method m, Transaction transaction, Request<JsonObject> request) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] values = this.calculateParamValues(session, m, request);
        Object result = m.invoke(object, values);
        if (result == null) {
            return null;
        }
        return new Response<JsonElement>(null, gson.toJsonTree(result));
    }

    private Object[] calculateParamValues(Session session, Method m, Request<JsonObject> request) {
        JsonObject params = request.getParams();
        String[] parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)m, true);
        Type[] parameterTypes = m.getGenericParameterTypes();
        Object[] values = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            values[i] = this.getValueFromParam(session, m, params, parameterNames[i], parameterTypes[i]);
        }
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < parameterNames.length; ++i) {
                sb.append(parameterNames[i] + "(" + String.valueOf(parameterTypes[i]) + ")=" + String.valueOf(values[i]) + ",");
            }
            sb.append("]");
            log.debug("Executing method {} with params {}", (Object)m.getName(), (Object)params);
        }
        return values;
    }

    private Object getValueFromParam(Session session, Method m, JsonObject params, String parameterName, Type genericType) {
        ParameterizedType genericMap;
        if (genericType instanceof Class) {
            Class type = (Class)genericType;
            if (Session.class.isAssignableFrom(type)) {
                return session;
            }
            JsonElement jsonElement = params.get(parameterName);
            if (jsonElement != null) {
                return this.getAsJavaType(type, jsonElement);
            }
            if (type == Boolean.TYPE) {
                return false;
            }
            if (type == Integer.TYPE) {
                return 0;
            }
        } else if (genericType instanceof ParameterizedType && Map.class.isAssignableFrom((Class)(genericMap = (ParameterizedType)genericType).getRawType()) && genericMap.getActualTypeArguments()[0] == String.class && genericMap.getActualTypeArguments()[1] == String.class) {
            HashMap<String, String> returnParams = new HashMap<String, String>();
            for (Map.Entry param : params.entrySet()) {
                String valueStr = !((JsonElement)param.getValue()).isJsonNull() ? ((JsonElement)param.getValue()).getAsString() : null;
                returnParams.put((String)param.getKey(), valueStr);
            }
            return returnParams;
        }
        return null;
    }

    private Object getAsJavaType(Class<?> type, JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (type == String.class) {
            return jsonElement.getClass().equals(JsonObject.class) ? jsonElement.toString() : jsonElement.getAsString();
        }
        if (type == Boolean.TYPE) {
            return jsonElement.getAsBoolean();
        }
        if (type.isEnum()) {
            return gson.fromJson(jsonElement, type);
        }
        if (type == Integer.TYPE) {
            return jsonElement.getAsInt();
        }
        return null;
    }
}

