/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OraclePooledConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleConnectionPoolDataSource
extends OracleDataSource
implements oracle.jdbc.datasource.OracleConnectionPoolDataSource {
    public OracleConnectionPoolDataSource() throws SQLException {
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
        this.connCachingEnabled = false;
        this.fastConnFailover = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String string = null;
        String string2 = null;
        OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
        synchronized (oracleConnectionPoolDataSource) {
            string = this.user;
            string2 = this.password != null ? this.password.get() : null;
        }
        return this.getPooledConnection(string, string2);
    }

    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        Connection connection = this.getPhysicalConnection(string, string2);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        if (string2 == null) {
            string2 = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string.startsWith("\"") ? string.toLowerCase() : string, string2);
        return oraclePooledConnection;
    }

    PooledConnection getPooledConnection(Properties properties) throws SQLException {
        String string;
        Connection connection = this.getPhysicalConnection(properties, null, null, null);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = properties.getProperty("password")) == null) {
            string = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password != null ? this.password.get() : null);
    }

    protected Connection getPhysicalConnection(String string, String string2, @Blind String string3) throws SQLException {
        this.url = string;
        return super.getConnection(string2, string3);
    }

    protected Connection getPhysicalConnection(String string, @Blind String string2) throws SQLException {
        return super.getConnection(string, string2);
    }

    protected OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        String string;
        Connection connection = super.getConnection(oracleConnectionBuilderImpl);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = oracleConnectionBuilderImpl.getUser();
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = oracleConnectionBuilderImpl.getPassword()) == null) {
            string = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        return new OraclePooledConnectionBuilderImpl(){

            @Override
            public oracle.jdbc.datasource.OraclePooledConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = OracleConnectionPoolDataSource.this.createConnectionBuilder().user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
                if (this.sslContext != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.sslContext(this.sslContext);
                }
                if (this.gssCredential != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.gssCredential(this.gssCredential);
                }
                if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return OracleConnectionPoolDataSource.this.getPooledConnection(oracleConnectionBuilderImpl);
            }
        };
    }
}

