/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.UUID;
import org.apache.wicket.util.crypt.ICrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrypt
implements ICrypt {
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(AbstractCrypt.class);
    private String encryptionKey = UUID.randomUUID().toString();

    @Override
    public final String decryptUrlSafe(String text) {
        try {
            byte[] decoded = Base64.getUrlDecoder().decode(text);
            return new String(this.decryptByteArray(decoded), CHARACTER_ENCODING);
        }
        catch (Exception ex) {
            log.debug("Error decoding text: " + text, (Throwable)ex);
            return null;
        }
    }

    @Override
    public final String encryptUrlSafe(String plainText) {
        try {
            byte[] encrypted = this.encryptStringToByteArray(plainText);
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            byte[] encoded = encoder.encode(encrypted);
            return new String(encoded, CHARACTER_ENCODING);
        }
        catch (GeneralSecurityException e) {
            log.error("Unable to encrypt text '" + plainText + "'", (Throwable)e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to encrypt text '" + plainText + "'", (Throwable)e);
            return null;
        }
    }

    public String getKey() {
        return this.encryptionKey;
    }

    public void setKey(String key) {
        this.encryptionKey = key;
    }

    protected abstract byte[] crypt(byte[] var1, int var2) throws GeneralSecurityException;

    private byte[] decryptByteArray(byte[] encrypted) {
        try {
            return this.crypt(encrypted, 2);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to decrypt the text '" + new String(encrypted) + "'", e);
        }
    }

    private byte[] encryptStringToByteArray(String plainText) throws GeneralSecurityException {
        try {
            return this.crypt(plainText.getBytes(CHARACTER_ENCODING), 1);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

