/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.asteriskjava.manager.event.ManagerEvent;

public abstract class AbstractRtcpEvent
extends ManagerEvent {
    private static final long serialVersionUID = 1L;
    private Long fractionLost;
    private Double dlSr;
    private Double iaJitter;

    public AbstractRtcpEvent(Object source) {
        super(source);
    }

    public Long getFractionLost() {
        return this.fractionLost;
    }

    public void setFractionLost(Long fractionLost) {
        this.fractionLost = fractionLost;
    }

    public Double getIaJitter() {
        return this.iaJitter;
    }

    public void setIaJitter(Double iaJitter) {
        this.iaJitter = iaJitter;
    }

    public Double getDlSr() {
        return this.dlSr;
    }

    public void setDlSr(String dlSrString) {
        this.dlSr = this.secStringToDouble(dlSrString);
    }

    protected Long secStringToLong(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.contains(".")) {
            return this.secStringToDouble(s).longValue();
        }
        if (s.endsWith("(sec)")) {
            return Long.parseLong(s.substring(0, s.length() - "(sec)".length()));
        }
        return Long.parseLong(s);
    }

    protected Double secStringToDouble(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.endsWith("(sec)")) {
            return Double.parseDouble(s.substring(0, s.length() - "(sec)".length()));
        }
        return Double.parseDouble(s);
    }

    protected InetAddress stringToAddress(String addressWithPort) {
        if (addressWithPort == null || addressWithPort.length() == 0) {
            return null;
        }
        String address = addressWithPort.lastIndexOf(58) > 0 ? addressWithPort.substring(0, addressWithPort.lastIndexOf(58)) : addressWithPort;
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to convert " + addressWithPort + " to InetAddress", e);
        }
    }

    protected Integer stringToPort(String addressWithPort) {
        if (addressWithPort == null || addressWithPort.length() == 0) {
            return null;
        }
        if (addressWithPort.lastIndexOf(58) <= 0) {
            return null;
        }
        String port = addressWithPort.substring(addressWithPort.lastIndexOf(58) + 1);
        return Integer.parseInt(port);
    }
}

