/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.dojo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.dojo.DojoConfig;
import org.apache.myfaces.custom.dojo.DojoResourceLoader;
import org.apache.myfaces.custom.dojo.DojoWidget;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;

public final class DojoUtils {
    private static final String MYFACES_DOJO_DEBUGCONSOLE_ID = "myfaces_Dojo_Debugger";
    private static final String DEBUG_CONSOLE_TYPE = "DebugConsole";
    private static final String LAYOUT_ALIGN_ATTR = "layoutAlign";
    private static final String DISPLAY_CLOSE_ACTION_ATTR = "displayCloseAction";
    private static final String RESIZABLE_ATTR = "resizable";
    private static final String HAS_SHADOW_ATTR = "hasShadow";
    private static final String CONSTRAIN_TO_CONTAINER_ATTR = "constrainToContainer";
    private static final String ICON_SRC_ATTR = "iconSrc";
    private static final String TITLE_ATTR = "title";
    private static final String INCL_TYPE_REQ_KEY = "DOJO_DEVELOPMENT_INCLUDE";
    private static final Log log = LogFactory.getLog(DojoUtils.class);
    private static final String DOJO_PROVIDE = "dojo.provide:";
    private static final String DOJO_REQUIRE = "dojo.require:";
    private static final String DOJO_NAMESPACE = "dojo.namespace:";
    private static final String DJCONFIG_INITKEY = "/*djconfig init*/";
    private static final String BODY_SCRIPT_INFOS_ATTRIBUTE_NAME = "bodyScriptInfos";
    private static final String DOJO_FILE_UNCOMPRESSED = "dojo.js.uncompressed.js";
    private static final String DOJO_FILE = "dojo.js";
    private static final String DJCONFIG_REQ_KEY = "MYFACES_DJCONFIG";
    private static final String DOJOEXTENSIONS_NAMESPACE = "dojo.setModulePrefix('extensions', '../dojoextensions.ResourceLoader');";

    private DojoUtils() {
    }

    public static Map getAttributeMap(FacesContext facesContext, String[] attributeNames, UIComponent component) {
        Log log = null;
        Class<?> componentClass = component.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (int cnt = 0; cnt < attributeNames.length; ++cnt) {
            try {
                Object execRetval;
                String attributeName = attributeNames[cnt];
                if (attributeName.equals("id") || attributeName.equals("widgetId")) {
                    String calculatedId = DojoUtils.calculateWidgetId(facesContext, component);
                    returnMap.put("id", calculatedId);
                    continue;
                }
                String attributeCasedName = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
                String getForm = "get" + attributeCasedName;
                String isForm = "is" + attributeCasedName;
                Method m = null;
                while (componentClass != null && m == null) {
                    m = componentClass.getDeclaredMethod(getForm, null);
                    if (m == null) {
                        m = componentClass.getDeclaredMethod(isForm, null);
                    }
                    if (m != null) continue;
                    componentClass = componentClass.getSuperclass();
                }
                if (m == null || (execRetval = m.invoke((Object)component, null)) == null) continue;
                returnMap.put(attributeName, execRetval);
                continue;
            }
            catch (Exception e) {
                if (log == null) {
                    log = LogFactory.getLog(DojoUtils.class);
                }
                log.error((Object)"getAttributeMap", (Throwable)e);
            }
        }
        return returnMap;
    }

    public static void addDebugConsole(FacesContext facesContext, UIComponent component) throws IOException {
        if (DojoUtils.isInlineScriptSet(facesContext, "/*DOJO DEBUGCONSOLE ON*/")) {
            return;
        }
        AddResource addResource = AddResourceFactory.getInstance(facesContext);
        addResource.addInlineScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, "/*DOJO DEBUGCONSOLE ON*/");
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)MYFACES_DOJO_DEBUGCONSOLE_ID, null);
        writer.writeAttribute("style", (Object)"width: 400px; height: 500px; left: 200px;", null);
        writer.endElement("div");
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(TITLE_ATTR, "MyFaces Dojo Debug console");
        attributeMap.put(ICON_SRC_ATTR, "images/flatScreen.gif");
        attributeMap.put(CONSTRAIN_TO_CONTAINER_ATTR, new Integer(1));
        attributeMap.put(HAS_SHADOW_ATTR, new Boolean(true));
        attributeMap.put(RESIZABLE_ATTR, new Boolean(true));
        attributeMap.put(DISPLAY_CLOSE_ACTION_ATTR, new Boolean(true));
        attributeMap.put(LAYOUT_ALIGN_ATTR, "client");
        DojoUtils.renderWidgetInitializationCode(writer, component, DEBUG_CONSOLE_TYPE, attributeMap, MYFACES_DOJO_DEBUGCONSOLE_ID, true);
    }

    public static boolean isDojoInitialized(FacesContext facesContext) {
        return DojoUtils.isInlineScriptCheck(facesContext, DJCONFIG_INITKEY);
    }

    public static void addMainInclude(FacesContext facesContext, UIComponent component, String javascriptLocation, DojoConfig config) throws IOException {
        AddResource addResource = AddResourceFactory.getInstance(facesContext);
        if (!DojoUtils.isInlineScriptSet(facesContext, DJCONFIG_INITKEY)) {
            String dojofile;
            addResource.addInlineScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, DJCONFIG_INITKEY);
            addResource.addInlineScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, config.toString());
            String string = dojofile = DojoUtils.getExpanded(facesContext) != null && DojoUtils.getExpanded(facesContext) != false ? DOJO_FILE_UNCOMPRESSED : DOJO_FILE;
            if (javascriptLocation != null) {
                addResource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + dojofile);
            } else {
                addResource.addJavaScriptAtPositionPlain(facesContext, AddResource.HEADER_BEGIN, DojoResourceLoader.class, dojofile);
            }
            addResource.addInlineScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, DOJOEXTENSIONS_NAMESPACE);
        }
    }

    public static void addNamespace(FacesContext facesContext, UIComponent component, String namespace, String location) throws IOException {
        if (DojoUtils.isInlineScriptSet(facesContext, DOJO_NAMESPACE + namespace)) {
            return;
        }
        String namespaceStr = DojoUtils.createNamespaceScript(namespace, location);
        DojoUtils.writeInlineScript(facesContext, component, namespaceStr);
    }

    public static void addProvide(FacesContext context, String provided) {
        if (DojoUtils.isInlineScriptSet(context, DOJO_PROVIDE + provided)) {
            return;
        }
        AddResource addResource = AddResourceFactory.getInstance(context);
        String providedBuilder = DojoUtils.createDojoProvideScript(provided);
        addResource.addInlineScriptAtPosition(context, AddResource.HEADER_BEGIN, providedBuilder);
    }

    public static void addProvide(FacesContext facesContext, UIComponent component, String provided) throws IOException {
        if (DojoUtils.isInlineScriptSet(facesContext, DOJO_PROVIDE + provided)) {
            return;
        }
        String providedBuilder = DojoUtils.createDojoProvideScript(provided);
        DojoUtils.writeInlineScript(facesContext, component, providedBuilder);
    }

    public static void addRequire(FacesContext facesContext, UIComponent component, String[] requires) throws IOException {
        for (int cnt = 0; cnt < requires.length; ++cnt) {
            DojoUtils.addRequire(facesContext, component, requires[cnt]);
        }
    }

    public static void addRequire(FacesContext facesContext, UIComponent component, String required) throws IOException {
        if (DojoUtils.isInlineScriptSet(facesContext, DOJO_REQUIRE + required)) {
            return;
        }
        String requireAsScript = DojoUtils.createDojoRequireString(required);
        DojoUtils.writeInlineScript(facesContext, component, requireAsScript);
    }

    public static String createDebugStatement(String stmnt) {
        return "dojo.debug(\"" + stmnt + "\");\n";
    }

    public static String createDebugStatement(String stmnt, String value) {
        return "dojo.debug(\"" + stmnt + ":\");dojo.debug(" + value + ");\n";
    }

    public static String createDojoProvideScript(String provided) {
        StringBuffer providedBuilder = new StringBuffer(32);
        providedBuilder.append("dojo.provide('");
        providedBuilder.append(provided.trim());
        providedBuilder.append("');");
        return providedBuilder.toString();
    }

    public static String createDojoRequireString(String required) {
        StringBuffer requiredBuilder = new StringBuffer(32);
        requiredBuilder.append("dojo.require('");
        requiredBuilder.append(required.trim());
        requiredBuilder.append("');");
        return requiredBuilder.toString();
    }

    public static DojoConfig getDjConfigInstance(FacesContext context) {
        DojoConfig djConfig = (DojoConfig)context.getExternalContext().getRequestMap().get(DJCONFIG_REQ_KEY);
        if (djConfig == null) {
            djConfig = new DojoConfig();
            context.getExternalContext().getRequestMap().put(DJCONFIG_REQ_KEY, djConfig);
        }
        return djConfig;
    }

    public static Boolean getExpanded(FacesContext facesContext) {
        Boolean devStatus = (Boolean)facesContext.getExternalContext().getRequestMap().get(INCL_TYPE_REQ_KEY);
        DojoConfig config = DojoUtils.getDjConfigInstance(facesContext);
        if (devStatus == null) {
            devStatus = new Boolean(false);
        }
        devStatus = new Boolean(devStatus != false || config.getDevelopment() != null && config.getDevelopment() != false);
        return devStatus;
    }

    public static boolean isInlineScriptSet(FacesContext context, String inlineScript) {
        Set set = DojoUtils.getBodyScriptInfos(context.getExternalContext().getRequestMap());
        if (!set.contains(inlineScript)) {
            set.add(inlineScript);
            return false;
        }
        return true;
    }

    public static boolean isInlineScriptCheck(FacesContext context, String inlineScript) {
        Set set = DojoUtils.getBodyScriptInfos(context.getExternalContext().getRequestMap());
        return set.contains(inlineScript);
    }

    public static String renderWidgetInitializationCode(FacesContext facesContext, UIComponent component, String dojoType, Map paramMap) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        return DojoUtils.renderWidgetInitializationCode(writer, component, dojoType, paramMap, clientId, true);
    }

    public static String renderWidgetInitializationCode(FacesContext facesContext, UIComponent component, String dojoType, String[] attributeNames) throws IOException {
        Map paramMap = DojoUtils.getAttributeMap(facesContext, attributeNames, component);
        return DojoUtils.renderWidgetInitializationCode(facesContext, component, dojoType, paramMap);
    }

    public static String renderWidgetInitializationCode(ResponseWriter writer, UIComponent component, String dojoType, Map paramMap, String clientId, boolean refId) throws IOException {
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String javascriptVar = (String)paramMap.get("widgetVar");
        if (StringUtils.isBlank((String)javascriptVar)) {
            javascriptVar = DojoUtils.calculateWidgetVarName(clientId);
        }
        Iterator it = paramMap.entrySet().iterator();
        writer.write("var ");
        writer.write(javascriptVar);
        writer.write(" = ");
        writer.write("dojo.widget.createWidget(\"");
        writer.write(dojoType);
        writer.write("\",");
        writer.write("{");
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!first) {
                writer.write(",");
            }
            writer.write(entry.getKey().toString());
            writer.write(":");
            boolean isString = value instanceof String;
            if (isString && (value.equals("true") || value.equals("false"))) {
                isString = false;
            }
            if (isString) {
                writer.write("'");
            }
            writer.write(value.toString());
            if (isString) {
                writer.write("'");
            }
            first = false;
        }
        writer.write("}");
        if (refId) {
            writer.write(",dojo.byId('");
            writer.write(clientId);
            writer.write("')");
        }
        writer.write(");");
        writer.endElement("script");
        return javascriptVar;
    }

    public static String calculateWidgetVarName(String clientId) {
        return clientId.replaceAll("\\:", "_") + "_dojoControl";
    }

    public static String calculateWidgetId(FacesContext context, UIComponent widget) {
        String widgetVarName = "";
        if (widget instanceof DojoWidget) {
            widgetVarName = ((DojoWidget)widget).getWidgetId();
        }
        if (StringUtils.isBlank((String)widgetVarName)) {
            widgetVarName = DojoUtils.calculateWidgetVarName(widget.getClientId(context));
        }
        return widgetVarName;
    }

    public static String calculateWidgetVarName(FacesContext context, UIComponent widget) {
        String widgetVarName = "";
        if (widget instanceof DojoWidget) {
            widgetVarName = ((DojoWidget)widget).getWidgetVar();
        }
        if (StringUtils.isBlank((String)widgetVarName)) {
            widgetVarName = DojoUtils.calculateWidgetVarName(widget.getClientId(context));
        }
        return widgetVarName;
    }

    public static void mergeExternalDjConfig(FacesContext context, DojoConfig config) {
        DojoConfig configSingleton = DojoUtils.getDjConfigInstance(context);
        Class<DojoConfig> dcConfigClass = DojoConfig.class;
        Method[] djConfigFieldArr = dcConfigClass.getMethods();
        for (int cnt = 0; cnt < djConfigFieldArr.length; ++cnt) {
            try {
                Object val;
                Method configPropertyField = djConfigFieldArr[cnt];
                String methodCore = null;
                if (!configPropertyField.getName().startsWith("getClass") && configPropertyField.getName().startsWith("get") || configPropertyField.getName().startsWith("is")) {
                    String string = methodCore = configPropertyField.getName().startsWith("get") ? configPropertyField.getName().substring(3) : configPropertyField.getName().substring(2);
                }
                if (methodCore == null || (val = configPropertyField.invoke((Object)config, null)) == null) continue;
                Class[] setterParams = new Class[]{val.getClass()};
                Method setMethod = dcConfigClass.getMethod("set" + methodCore, setterParams);
                if (setMethod == null) continue;
                Object[] setterArgs = new Object[]{val};
                setMethod.invoke((Object)configSingleton, setterArgs);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                continue;
            }
            catch (SecurityException e) {
                log.error((Object)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e);
            }
        }
    }

    public static void setExpanded(FacesContext facesContext, Boolean expanded) {
        facesContext.getExternalContext().getRequestMap().put(INCL_TYPE_REQ_KEY, expanded);
    }

    public static void writeDebugStatement(ResponseWriter writer, String stmnt) throws IOException {
        stmnt = DojoUtils.createDebugStatement(stmnt);
        writer.write(stmnt);
    }

    private static String createNamespaceScript(String namespace, String location) {
        StringBuffer namespaceBuilder = new StringBuffer(32);
        namespaceBuilder.append("dojo.hostenv.setModulePrefix('");
        namespaceBuilder.append(namespace);
        namespaceBuilder.append("','");
        namespaceBuilder.append(location);
        namespaceBuilder.append("');");
        String namespaceStr = namespaceBuilder.toString();
        return namespaceStr;
    }

    private static Set getBodyScriptInfos(Map requestMap) {
        TreeSet set = (TreeSet)requestMap.get(BODY_SCRIPT_INFOS_ATTRIBUTE_NAME);
        if (set == null) {
            set = new TreeSet();
            requestMap.put(BODY_SCRIPT_INFOS_ATTRIBUTE_NAME, set);
        }
        return set;
    }

    private static void writeInlineScript(FacesContext facesContext, UIComponent component, String script) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(script);
        writer.endElement("script");
    }
}

