/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.myfaces.application.viewstate.SerializedViewKey;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializedViewCollection
implements Serializable {
    private static final Logger log = Logger.getLogger(SerializedViewCollection.class.getName());
    private static final Object[] EMPTY_STATES = new Object[]{null, null};
    private static final long serialVersionUID = -3734849062185115847L;
    private final List<SerializedViewKey> _keys = new ArrayList<SerializedViewKey>(20);
    private final Map<SerializedViewKey, Object> _serializedViews = new HashMap<SerializedViewKey, Object>();
    private final Map<SerializedViewKey, SerializedViewKey> _precedence = new HashMap<SerializedViewKey, SerializedViewKey>();
    private transient Map<Object, Object> _oldSerializedViews = null;

    SerializedViewCollection() {
    }

    public synchronized void add(FacesContext context, Object state, SerializedViewKey key, SerializedViewKey previousRestoredKey) {
        if (state == null) {
            state = EMPTY_STATES;
        } else if (state instanceof Object[] && state.length == 2 && state[0] == null && state[1] == null) {
            state = null;
        }
        Integer maxCount = this.getNumberOfSequentialViewsInSession(context);
        if (maxCount != null && previousRestoredKey != null) {
            if (!this._serializedViews.isEmpty()) {
                this._precedence.put(key, previousRestoredKey);
            } else {
                previousRestoredKey = null;
            }
        }
        this._serializedViews.put(key, state);
        while (this._keys.remove(key)) {
        }
        this._keys.add(key);
        if (previousRestoredKey != null && maxCount != null && maxCount > 0) {
            int count = 0;
            SerializedViewKey previousKey = key;
            while ((previousKey = this._precedence.get(previousKey)) != null && ++count < maxCount) {
            }
            if (previousKey != null) {
                SerializedViewKey keyToRemove = previousKey;
                while (true) {
                    if (this._keys.remove(keyToRemove)) {
                        continue;
                    }
                    if (this._serializedViews.containsKey(keyToRemove) && !"off".equals(this.getCacheOldViewsInSessionMode(context))) {
                        Object[] removedValue = this._serializedViews.remove(keyToRemove);
                        if (removedValue == null) {
                            removedValue = EMPTY_STATES;
                        }
                        this.getOldSerializedViewsMap().put(keyToRemove, removedValue);
                    } else {
                        this._serializedViews.remove(keyToRemove);
                    }
                    if ((keyToRemove = this._precedence.remove(keyToRemove)) == null) break;
                }
            }
        }
        int views = this.getNumberOfViewsInSession(context);
        while (this._keys.size() > views) {
            key = this._keys.remove(0);
            if (maxCount != null && maxCount > 0) {
                SerializedViewKey keyToRemove = key;
                while ((keyToRemove = this._precedence.remove(keyToRemove)) != null) {
                }
            }
            if (this._serializedViews.containsKey(key) && !"off".equals(this.getCacheOldViewsInSessionMode(context))) {
                Object[] removedValue = this._serializedViews.remove(key);
                if (removedValue == null) {
                    removedValue = EMPTY_STATES;
                }
                this.getOldSerializedViewsMap().put(key, removedValue);
                continue;
            }
            this._serializedViews.remove(key);
        }
    }

    protected Integer getNumberOfSequentialViewsInSession(FacesContext context) {
        return WebConfigParamUtils.getIntegerInitParameter(context.getExternalContext(), "org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION");
    }

    protected int getNumberOfViewsInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter("org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION");
        int views = 20;
        if (value != null) {
            try {
                views = Integer.parseInt(value);
                if (views <= 0) {
                    log.severe("Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                    views = 20;
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage(), e);
            }
        }
        return views;
    }

    protected Map<Object, Object> getOldSerializedViewsMap() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this._oldSerializedViews == null && context != null) {
            String cacheMode = this.getCacheOldViewsInSessionMode(context);
            if ("weak".equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(2, 2, true);
            } else if ("soft-weak".equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(1, 2, true);
            } else if ("soft".equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(1, 1, true);
            } else if ("hard-soft".equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(0, 1);
            }
        }
        return this._oldSerializedViews;
    }

    protected String getCacheOldViewsInSessionMode(FacesContext context) {
        String value = context.getExternalContext().getInitParameter("org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE");
        if (value == null) {
            return "off";
        }
        if (value.equalsIgnoreCase("soft")) {
            return "soft";
        }
        if (value.equalsIgnoreCase("soft-weak")) {
            return "soft-weak";
        }
        if (value.equalsIgnoreCase("weak")) {
            return "weak";
        }
        if (value.equalsIgnoreCase("hard-soft")) {
            return "hard-soft";
        }
        return "off";
    }

    public Object get(SerializedViewKey key) {
        Object value = this._serializedViews.get(key);
        if (value == null) {
            if (this._serializedViews.containsKey(key)) {
                return EMPTY_STATES;
            }
            Map<Object, Object> oldSerializedViewMap = this.getOldSerializedViewsMap();
            if (oldSerializedViewMap != null && (value = oldSerializedViewMap.get(key)) == null && oldSerializedViewMap.containsKey(key)) {
                return EMPTY_STATES;
            }
        } else if (value instanceof Object[] && ((Object[])value).length == 2 && ((Object[])value)[0] == null && ((Object[])value)[1] == null) {
            return null;
        }
        return value;
    }
}

