/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventImpl
implements JackrabbitEvent {
    private static final Logger log = LoggerFactory.getLogger((Class)EventImpl.class);
    private final SessionImpl session;
    private final EventState eventState;
    private String stringValue;

    EventImpl(SessionImpl session, EventState eventState) {
        this.session = session;
        this.eventState = eventState;
    }

    public int getType() {
        return this.eventState.getType();
    }

    public String getPath() throws RepositoryException {
        return this.session.getJCRPath(this.getQPath());
    }

    public String getUserID() {
        return this.eventState.getUserId();
    }

    public Path getQPath() throws RepositoryException {
        try {
            Path parent = this.eventState.getParentPath();
            Path.Element child = this.eventState.getChildRelPath();
            int index = child.getIndex();
            if (index > 0) {
                return PathFactoryImpl.getInstance().create(parent, child.getName(), index, false);
            }
            return PathFactoryImpl.getInstance().create(parent, child.getName(), false);
        }
        catch (MalformedPathException e) {
            String msg = "internal error: malformed path for event";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NodeId getParentId() {
        return this.eventState.getParentId();
    }

    public NodeId getChildId() {
        return this.eventState.getChildId();
    }

    public boolean isExternal() {
        return this.eventState.isExternal();
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Event: Path: ");
            try {
                sb.append(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Exception retrieving path: " + (Object)((Object)e));
                sb.append("[Error retrieving path]");
            }
            sb.append(", ").append(EventState.valueOf(this.getType())).append(": ");
            sb.append(", UserId: ").append(this.getUserID());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        return this.eventState.hashCode() ^ this.session.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventImpl) {
            EventImpl other = (EventImpl)obj;
            return this.eventState.equals(other.eventState) && this.session.equals(other.session);
        }
        return false;
    }
}

