/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.websockets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.vysper.xmpp.extension.websockets.WebSocketBackedSessionContext;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppWebSocketServlet
extends WebSocketServlet {
    public static final String SERVER_RUNTIME_CONTEXT_ATTRIBUTE = "org.apache.vysper.xmpp.server.ServerRuntimeContext";
    private static final Logger LOG = LoggerFactory.getLogger(XmppWebSocketServlet.class);
    private static final long serialVersionUID = 197413099255392883L;
    private static final String SUB_PROTOCOL = "xmpp";
    private ServerRuntimeContext serverRuntimeContext;

    public XmppWebSocketServlet() {
    }

    public XmppWebSocketServlet(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void init() throws ServletException {
        super.init();
        if (this.serverRuntimeContext == null) {
            this.serverRuntimeContext = (ServerRuntimeContext)this.getServletContext().getAttribute(SERVER_RUNTIME_CONTEXT_ATTRIBUTE);
            if (this.serverRuntimeContext == null) {
                throw new RuntimeException("Failed to get Vysper ServerRuntimeContext from servlet context attribute \"org.apache.vysper.xmpp.server.ServerRuntimeContext\"");
            }
        }
    }

    protected WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        if (SUB_PROTOCOL.equals(protocol)) {
            WebSocketBackedSessionContext sessionContext = new WebSocketBackedSessionContext(this.serverRuntimeContext);
            return sessionContext;
        }
        LOG.warn("Unsupported WebSocket sub protocol, must be \"xmpp\"");
        return null;
    }
}

