/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableName;

public class LockTableNode
extends MiscellaneousStatementNode {
    private TableName tableName;
    private boolean exclusiveMode;
    private long conglomerateNumber;
    private TableDescriptor lockTableDescriptor;

    public void init(Object object, Object object2) {
        this.tableName = (TableName)object;
        this.exclusiveMode = (Boolean)object2;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "LOCK TABLE";
    }

    public QueryTreeNode bind() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
        if (schemaDescriptor.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)string);
        }
        this.lockTableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), schemaDescriptor);
        if (this.lockTableDescriptor == null) {
            TableName tableName = this.resolveTableToSynonym(this.tableName);
            if (tableName == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = tableName;
            schemaDescriptor = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.lockTableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
            if (this.lockTableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        if (this.lockTableDescriptor.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.conglomerateNumber = this.lockTableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.lockTableDescriptor.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.lockTableDescriptor);
        compilerContext.createDependency(conglomerateDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(0);
            compilerContext.addRequiredTablePriv(this.lockTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.lockTableDescriptor.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getLockTableConstantAction(this.tableName.getFullTableName(), this.conglomerateNumber, this.exclusiveMode);
    }
}

