/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common.logging;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.mvndaemon.mvnd.common.Message;
import org.mvndaemon.mvnd.common.OsUtils;
import org.mvndaemon.mvnd.common.logging.ClientOutput;

public class TerminalOutput
implements ClientOutput {
    public static final int KEY_PLUS = 43;
    public static final int KEY_MINUS = 45;
    public static final int KEY_CTRL_B = 2;
    public static final int KEY_CTRL_L = 12;
    public static final int KEY_CTRL_M = 13;
    private static final AttributedStyle GREEN_FOREGROUND = new AttributedStyle().foreground(2);
    private static final AttributedStyle CYAN_FOREGROUND = new AttributedStyle().foreground(6);
    private final Terminal terminal;
    private final Terminal.SignalHandler previousIntHandler;
    private final Display display;
    private final Map<String, Map<String, Message.TransferEvent>> transfers = new LinkedHashMap<String, Map<String, Message.TransferEvent>>();
    private final ArrayList<Message.ExecutionFailureEvent> failures = new ArrayList();
    private final LinkedHashMap<String, Project> projects = new LinkedHashMap();
    private final ClientLog log;
    private final Thread reader;
    private volatile Exception exception;
    private volatile boolean closing;
    private final long start;
    private final ReadWriteLock readInput = new ReentrantReadWriteLock();
    private final boolean dumb;
    private volatile Consumer<Message> daemonDispatch;
    private volatile Consumer<Message> daemonReceive;
    private volatile String projectReadingInput;
    private String name;
    private String daemonId;
    private int totalProjects;
    private String projectsDoneFomat;
    private int maxThreads;
    private String artifactIdFormat;
    private String threadsFormat;
    private int linesPerProject = 0;
    private int doneProjects = 0;
    private String buildStatus;
    private boolean displayDone = false;
    private boolean noBuffering;

    public TerminalOutput(boolean noBuffering, int rollingWindowSize, Path logFile) throws IOException {
        this.start = System.currentTimeMillis();
        TerminalBuilder builder = TerminalBuilder.builder();
        builder.systemOutput(TerminalBuilder.SystemOutput.SysErr);
        this.terminal = builder.build();
        this.dumb = this.terminal.getType().startsWith("dumb");
        this.noBuffering = noBuffering;
        this.linesPerProject = rollingWindowSize;
        this.terminal.enterRawMode();
        Thread mainThread = Thread.currentThread();
        this.daemonDispatch = m -> {
            if (m == Message.BareMessage.CANCEL_BUILD_SINGLETON) {
                mainThread.interrupt();
            }
        };
        this.previousIntHandler = this.terminal.handle(Terminal.Signal.INT, sig -> this.daemonDispatch.accept(Message.BareMessage.CANCEL_BUILD_SINGLETON));
        this.display = new Display(this.terminal, false);
        ClientLog clientLog = this.log = logFile == null ? new MessageCollector() : new FileLog(logFile);
        if (!this.dumb) {
            Thread r = new Thread(this::readInputLoop);
            r.setDaemon(true);
            r.start();
            this.reader = r;
        } else {
            this.reader = null;
        }
    }

    @Override
    public void setDaemonId(String daemonId) {
        this.daemonId = daemonId;
    }

    @Override
    public void setDaemonDispatch(Consumer<Message> daemonDispatch) {
        this.daemonDispatch = daemonDispatch;
    }

    @Override
    public void setDaemonReceive(Consumer<Message> daemonReceive) {
        this.daemonReceive = daemonReceive;
    }

    @Override
    public void accept(Message entry) {
        assert ("main".equals(Thread.currentThread().getName()));
        if (this.doAccept(entry)) {
            this.update();
        }
    }

    @Override
    public void accept(List<Message> entries) {
        assert ("main".equals(Thread.currentThread().getName()));
        for (Message entry : entries) {
            if (this.doAccept(entry)) continue;
            return;
        }
        this.update();
    }

    private boolean doAccept(Message entry) {
        block6 : switch (entry.getType()) {
            case 2: {
                Message.BuildStarted bs = (Message.BuildStarted)entry;
                this.name = bs.getProjectId();
                this.totalProjects = bs.getProjectCount();
                int totalProjectsDigits = (int)(Math.log10(this.totalProjects) + 1.0);
                this.projectsDoneFomat = "%" + totalProjectsDigits + "d";
                this.maxThreads = bs.getMaxThreads();
                this.artifactIdFormat = "%-" + bs.getArtifactIdDisplayLength() + "s ";
                int maxThreadsDigits = (int)(Math.log10(this.maxThreads) + 1.0);
                this.threadsFormat = "%" + (maxThreadsDigits * 3 + 2) + "s";
                if (this.maxThreads > 1 && this.totalProjects > 1) break;
                this.noBuffering = true;
                this.display.update(Collections.emptyList(), 0);
                this.applyNoBuffering();
                break;
            }
            case 17: {
                this.projects.values().stream().flatMap(p -> p.log.stream()).forEach(this.log);
                this.clearDisplay();
                try {
                    this.log.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                AttributedStyle s = new AttributedStyle().bold().foreground(1);
                new AttributedString((CharSequence)"The build was canceled", s).println(this.terminal);
                this.terminal.flush();
                return false;
            }
            case 9: {
                Message.BuildException e = (Message.BuildException)entry;
                String msg = "org.apache.commons.cli.UnrecognizedOptionException".equals(e.getClassName()) ? "Unable to parse command line options: " + e.getMessage() : e.getClassName() + ": " + e.getMessage();
                this.projects.values().stream().flatMap(p -> p.log.stream()).forEach(this.log);
                this.clearDisplay();
                try {
                    this.log.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                AttributedStyle s = new AttributedStyle().bold().foreground(1);
                new AttributedString((CharSequence)msg, s).println(this.terminal);
                this.terminal.flush();
                return false;
            }
            case 4: {
                Message.StringMessage be = (Message.StringMessage)entry;
                String artifactId = be.getMessage();
                this.projects.put(artifactId, new Project(artifactId));
                break;
            }
            case 6: {
                Message.MojoStartedEvent execution = (Message.MojoStartedEvent)entry;
                Project prj = this.projects.computeIfAbsent(execution.getArtifactId(), Project::new);
                prj.runningExecution = execution;
                break;
            }
            case 5: {
                Message.StringMessage be = (Message.StringMessage)entry;
                String artifactId = be.getMessage();
                Project prj = (Project)this.projects.remove(artifactId);
                if (prj != null) {
                    prj.log.forEach(this.log);
                }
                ++this.doneProjects;
                this.displayDone();
                break;
            }
            case 15: {
                this.buildStatus = ((Message.StringMessage)entry).getMessage();
                break;
            }
            case 3: {
                this.projects.values().stream().flatMap(p -> p.log.stream()).forEach(this.log);
                this.clearDisplay();
                try {
                    this.log.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.terminal.flush();
                }
                return false;
            }
            case 10: {
                break;
            }
            case 12: {
                this.clearDisplay();
                Message.ProjectEvent d = (Message.ProjectEvent)entry;
                this.terminal.writer().printf("[%s] %s%n", d.getProjectId(), d.getMessage());
                break;
            }
            case 25: {
                Message.StringMessage d = (Message.StringMessage)entry;
                if (this.log instanceof FileLog) {
                    this.log.accept(d.getMessage());
                    break;
                }
                this.clearDisplay();
                System.out.printf("%s%n", d.getMessage());
                break;
            }
            case 26: {
                Message.StringMessage d = (Message.StringMessage)entry;
                if (this.log instanceof FileLog) {
                    this.log.accept(d.getMessage());
                    break;
                }
                this.clearDisplay();
                System.err.printf("%s%n", d.getMessage());
                break;
            }
            case 13: {
                Message.Prompt prompt = (Message.Prompt)entry;
                if (this.dumb) {
                    this.terminal.writer().println("");
                    break;
                }
                this.readInput.writeLock().lock();
                try {
                    this.clearDisplay();
                    if (prompt.getMessage() != null) {
                        String msg = this.maxThreads > 1 ? String.format("[%s] %s", prompt.getProjectId(), prompt.getMessage()) : prompt.getMessage();
                        this.terminal.writer().print(msg);
                    }
                    this.terminal.flush();
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        int c;
                        if ((c = this.terminal.reader().read()) < 0) {
                            break block6;
                        }
                        if (c == 10 || c == 13) {
                            this.terminal.writer().println();
                            this.daemonDispatch.accept(prompt.response(sb.toString()));
                            break block6;
                        }
                        if (c == 127) {
                            if (sb.length() <= 0) continue;
                            sb.setLength(sb.length() - 1);
                            this.terminal.writer().write("\b \b");
                            this.terminal.writer().flush();
                            continue;
                        }
                        this.terminal.writer().print((char)c);
                        this.terminal.writer().flush();
                        sb.append((char)c);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.readInput.writeLock().unlock();
                }
            }
            case 8: {
                Message.StringMessage sm = (Message.StringMessage)entry;
                this.log.accept(sm.getMessage());
                break;
            }
            case 7: {
                Message.ProjectEvent bm = (Message.ProjectEvent)entry;
                Project prj = this.projects.get(bm.getProjectId());
                if (prj == null) {
                    this.log.accept(bm.getMessage());
                    break;
                }
                if (this.noBuffering || this.dumb) {
                    String msg = this.maxThreads > 1 ? String.format("[%s] %s", bm.getProjectId(), bm.getMessage()) : bm.getMessage();
                    this.log.accept(msg);
                    break;
                }
                prj.log.add(bm.getMessage());
                break;
            }
            case 16: {
                char keyStroke = ((Message.StringMessage)entry).getMessage().charAt(0);
                switch (keyStroke) {
                    case '+': {
                        this.linesPerProject = Math.min(10, this.linesPerProject + 1);
                        break;
                    }
                    case '-': {
                        this.linesPerProject = Math.max(0, this.linesPerProject - 1);
                        break;
                    }
                    case '\u0002': {
                        boolean bl = this.noBuffering = !this.noBuffering;
                        if (this.noBuffering) {
                            this.applyNoBuffering();
                            break;
                        }
                        this.clearDisplay();
                        break;
                    }
                    case '\f': {
                        this.clearDisplay();
                        break;
                    }
                    case '\r': {
                        this.displayDone = !this.displayDone;
                        this.displayDone();
                    }
                }
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                Message.TransferEvent te = (Message.TransferEvent)entry;
                this.transfers.computeIfAbsent(this.orEmpty(te.getProjectId()), p -> new LinkedHashMap()).put(te.getResourceName(), te);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                Message.TransferEvent te = (Message.TransferEvent)entry;
                this.transfers.computeIfAbsent(this.orEmpty(te.getProjectId()), p -> new LinkedHashMap()).remove(te.getResourceName());
                break;
            }
            case 24: {
                Message.ExecutionFailureEvent efe = (Message.ExecutionFailureEvent)entry;
                this.failures.add(efe);
                break;
            }
            case 27: {
                Message.RequestInput ri = (Message.RequestInput)entry;
                this.projectReadingInput = ri.getProjectId();
                break;
            }
            case 28: {
                this.daemonDispatch.accept(entry);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message " + entry);
            }
        }
        return true;
    }

    private String orEmpty(String s) {
        return s != null ? s : "";
    }

    private void applyNoBuffering() {
        this.projects.values().stream().flatMap(p -> p.log.stream()).forEach(this.log);
        this.projects.clear();
    }

    @Override
    public void describeTerminal() {
        StringBuilder sb = new StringBuilder();
        sb.append("Terminal: ").append(this.terminal != null ? this.terminal.getClass().getName() : null);
        if (this.terminal instanceof AbstractPosixTerminal) {
            sb.append(" with pty ").append(((AbstractPosixTerminal)this.terminal).getPty().getClass().getName());
        }
        this.accept(Message.log(sb.toString()));
    }

    @Override
    public int getTerminalWidth() {
        return this.terminal.getWidth();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    void readInputLoop() {
        try {
            while (!this.closing) {
                if (!this.readInput.readLock().tryLock(10L, TimeUnit.MILLISECONDS)) continue;
                if (this.projectReadingInput != null) {
                    int c;
                    char[] buf = new char[256];
                    int idx = 0;
                    while (idx < buf.length && (c = this.terminal.reader().read(idx > 0 ? 1L : 10L)) >= 0) {
                        buf[idx++] = (char)c;
                    }
                    if (idx > 0) {
                        String data = String.valueOf(buf, 0, idx);
                        this.daemonReceive.accept(Message.inputResponse(data));
                    }
                } else {
                    int c = this.terminal.reader().read(10L);
                    if (c == -1) break;
                    if (c == 43 || c == 45 || c == 12 || c == 13 || c == 2) {
                        this.daemonReceive.accept(Message.keyboardInput((char)c));
                    }
                }
                this.readInput.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    private void clearDisplay() {
        if (!this.noBuffering && !this.dumb) {
            this.display.update(Collections.emptyList(), 0);
        }
    }

    private void displayDone() {
        if (this.displayDone) {
            try {
                this.log.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.closing = true;
        if (this.reader != null) {
            this.reader.interrupt();
        }
        this.log.close();
        this.terminal.handle(Terminal.Signal.INT, this.previousIntHandler);
        this.terminal.close();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void update() {
        AttributedString globalTransfer;
        if (this.noBuffering || this.dumb) {
            try {
                this.log.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        Size size = this.terminal.getSize();
        int rows = size.getRows();
        int cols = size.getColumns();
        this.display.resize(rows, size.getColumns());
        if (rows <= 0) {
            this.clearDisplay();
            return;
        }
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>(rows);
        int projectsCount = this.projects.size();
        int dispLines = rows;
        --dispLines;
        this.addStatusLine(lines, --dispLines, projectsCount);
        AttributedString globalFailure = this.formatFailures();
        if (globalFailure != null) {
            lines.add(globalFailure);
            --dispLines;
        }
        if ((globalTransfer = this.formatTransfers("")) != null) {
            lines.add(globalTransfer);
            --dispLines;
        }
        if (projectsCount <= dispLines) {
            int remLogLines = dispLines - projectsCount;
            for (Project prj : this.projects.values()) {
                this.addProjectLine(lines, prj);
                int nb = Math.min(remLogLines, this.linesPerProject);
                List logs = TerminalOutput.lastN(prj.log, nb).stream().flatMap(s -> AttributedString.fromAnsi((String)s).columnSplitLength(Integer.MAX_VALUE).stream()).map(s -> TerminalOutput.concat("   ", s)).collect(TerminalOutput.lastN(nb));
                lines.addAll(logs);
                remLogLines -= logs.size();
            }
            while (remLogLines-- > 0 && lines.size() <= this.maxThreads + 1) {
                lines.add(AttributedString.EMPTY);
            }
        } else {
            int skipProjects = projectsCount - dispLines;
            for (Project prj : this.projects.values()) {
                if (skipProjects == 0) {
                    this.addProjectLine(lines, prj);
                    continue;
                }
                --skipProjects;
            }
        }
        List trimmed = lines.stream().map(s -> s.columnSubSequence(0, cols)).collect(Collectors.toList());
        this.display.update(trimmed, -1);
    }

    private AttributedString formatFailures() {
        if (this.failures.isEmpty()) {
            return null;
        }
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.style(AttributedStyle.DEFAULT.foreground(1).bold());
        if (this.failures.stream().anyMatch(Message.ExecutionFailureEvent::isHalted)) {
            asb.append((CharSequence)"ABORTING ");
        }
        asb.append((CharSequence)"FAILURE: ");
        asb.style(AttributedStyle.DEFAULT.foreground(1));
        if (this.failures.size() == 1) {
            Message.ExecutionFailureEvent efe = this.failures.iterator().next();
            asb.append((CharSequence)efe.getProjectId());
            String exception = efe.getException();
            if (exception != null) {
                if (exception.startsWith("org.apache.maven.lifecycle.LifecycleExecutionException: ")) {
                    exception = exception.substring("org.apache.maven.lifecycle.LifecycleExecutionException: ".length());
                }
                asb.append((CharSequence)": ").append((CharSequence)exception);
            }
        } else {
            asb.append((CharSequence)String.valueOf(this.failures.size())).append((CharSequence)" projects failed: ");
            asb.append((CharSequence)this.failures.stream().map(Message.ExecutionFailureEvent::getProjectId).collect(Collectors.joining(", ")));
        }
        AttributedString as = asb.toAttributedString();
        if (as.columnLength() >= this.getTerminalWidth() - 1) {
            asb = new AttributedStringBuilder();
            asb.append(as.columnSubSequence(0, this.getTerminalWidth() - 2));
            asb.style(AttributedStyle.DEFAULT);
            asb.append((CharSequence)"\u2026");
            as = asb.toAttributedString();
        }
        return as;
    }

    private AttributedString formatTransfers(String projectId) {
        String action;
        Collection transfers = this.transfers.getOrDefault(projectId, Collections.emptyMap()).values();
        if (transfers.isEmpty()) {
            return null;
        }
        Message.TransferEvent event = (Message.TransferEvent)transfers.iterator().next();
        String string = action = event.getRequestType() == 2 ? "Uploading" : "Downloading";
        if (transfers.size() == 1) {
            String direction = event.getRequestType() == 2 ? "to" : "from";
            long cur = event.getTransferredBytes();
            long max = event.getContentLength();
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append((CharSequence)action);
            asb.append(' ');
            asb.style(AttributedStyle.BOLD);
            asb.append((CharSequence)TerminalOutput.pathToMaven(event.getResourceName()));
            asb.style(AttributedStyle.DEFAULT);
            asb.append(' ');
            asb.append((CharSequence)direction);
            asb.append(' ');
            asb.append((CharSequence)event.getRepositoryId());
            if (cur > 0L && cur < max) {
                asb.append(' ');
                asb.append((CharSequence)OsUtils.bytesToHumanReadable(cur));
                asb.append('/');
                asb.append((CharSequence)OsUtils.bytesToHumanReadable(max));
            }
            return asb.toAttributedString();
        }
        return new AttributedString((CharSequence)(action + " " + transfers.size() + " files..."));
    }

    public static String pathToMaven(String location) {
        String[] p = location.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuilder sb = new StringBuilder();
            String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
            String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append(':').append(artifactId).append(':').append(version);
            if (!"jar".equals(type) || classifier != null) {
                sb.append(':');
                if (!"jar".equals(type)) {
                    sb.append(type);
                }
                if (classifier != null) {
                    sb.append(':').append(classifier);
                }
            }
            return sb.toString();
        }
        return location;
    }

    private void addStatusLine(List<AttributedString> lines, int dispLines, int projectsCount) {
        if (this.name != null || this.buildStatus != null) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            if (this.name != null) {
                asb.append((CharSequence)"Building ");
                asb.style(AttributedStyle.BOLD);
                asb.append((CharSequence)this.name);
                asb.style(AttributedStyle.DEFAULT);
                asb.append((CharSequence)"  daemon: ").style(AttributedStyle.BOLD).append((CharSequence)this.daemonId).style(AttributedStyle.DEFAULT);
                asb.append((CharSequence)"  threads used/hidden/max: ").style(AttributedStyle.BOLD).append((CharSequence)String.format(this.threadsFormat, new StringBuilder(this.threadsFormat.length()).append(projectsCount).append('/').append(Math.max(0, projectsCount - dispLines)).append('/').append(this.maxThreads).toString())).style(AttributedStyle.DEFAULT);
                asb.append((CharSequence)"  progress: ").style(AttributedStyle.BOLD).append((CharSequence)String.format(this.projectsDoneFomat, this.doneProjects)).append('/').append((CharSequence)String.valueOf(this.totalProjects)).append(' ').append((CharSequence)String.format("%3d", this.doneProjects * 100 / this.totalProjects)).append('%').style(AttributedStyle.DEFAULT);
            } else if (this.buildStatus != null) {
                asb.style(AttributedStyle.BOLD).append((CharSequence)this.buildStatus).style(AttributedStyle.DEFAULT);
            }
            long sec = (System.currentTimeMillis() - this.start) / 1000L;
            asb.append((CharSequence)"  time: ").style(AttributedStyle.BOLD).append((CharSequence)String.format("%02d:%02d", sec / 60L, sec % 60L)).style(AttributedStyle.DEFAULT);
            lines.add(asb.toAttributedString());
        }
    }

    private void addProjectLine(List<AttributedString> lines, Project prj) {
        Message.MojoStartedEvent execution = prj.runningExecution;
        AttributedStringBuilder asb = new AttributedStringBuilder();
        AttributedString transfer = this.formatTransfers(prj.id);
        if (transfer != null) {
            asb.append(':').style(CYAN_FOREGROUND).append((CharSequence)String.format(this.artifactIdFormat, prj.id)).style(AttributedStyle.DEFAULT).append(transfer);
        } else if (execution == null) {
            asb.append(':').style(CYAN_FOREGROUND).append((CharSequence)prj.id);
        } else {
            asb.append(':').style(CYAN_FOREGROUND).append((CharSequence)String.format(this.artifactIdFormat, prj.id)).style(GREEN_FOREGROUND);
            if (execution.getPluginGoalPrefix().isEmpty()) {
                asb.append((CharSequence)execution.getPluginGroupId()).append(':').append((CharSequence)execution.getPluginArtifactId());
            } else {
                asb.append((CharSequence)execution.getPluginGoalPrefix());
            }
            asb.append(':').append((CharSequence)execution.getPluginVersion()).append(':').append((CharSequence)execution.getMojo()).append(' ').style(AttributedStyle.DEFAULT).append('(').append((CharSequence)execution.getExecutionId()).append(')');
        }
        lines.add(asb.toAttributedString());
    }

    private static <T> List<T> lastN(List<T> list, int n) {
        return list.subList(Math.max(0, list.size() - n), list.size());
    }

    private static <T> Collector<T, ?, List<T>> lastN(int n) {
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (n > 0) {
                if (acc.size() == n) {
                    acc.pollFirst();
                }
                acc.add(t);
            }
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    private static AttributedString concat(String s1, AttributedString s2) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append((CharSequence)s1);
        asb.append(s2);
        return asb.toAttributedString();
    }

    class MessageCollector
    implements ClientLog {
        private final List<String> messages = new ArrayList<String>();

        MessageCollector() {
        }

        @Override
        public void accept(String message) {
            this.messages.add(message);
        }

        @Override
        public void flush() {
            TerminalOutput.this.clearDisplay();
            this.messages.forEach(System.out::println);
            this.messages.clear();
            TerminalOutput.this.terminal.flush();
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    static class FileLog
    implements ClientLog {
        private final Writer out;
        private final Path logFile;

        public FileLog(Path logFile) throws IOException {
            this.out = Files.newBufferedWriter(logFile, StandardCharsets.UTF_8, new OpenOption[0]);
            this.logFile = logFile;
        }

        @Override
        public void accept(String message) {
            try {
                this.out.write(message);
                this.out.write(10);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write to " + this.logFile, e);
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static interface ClientLog
    extends Consumer<String> {
        @Override
        public void accept(String var1);

        public void flush() throws IOException;

        public void close() throws IOException;
    }

    static class Project {
        final String id;
        Message.MojoStartedEvent runningExecution;
        final List<String> log = new ArrayList<String>();

        public Project(String id) {
            this.id = id;
        }
    }
}

