/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.CmisServiceValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

public class InMemoryAbstractServiceImpl {
    protected final StoreManager fStoreManager;
    protected final CmisServiceValidator validator;
    protected final AtomLinkInfoProvider fAtomLinkProvider;

    protected InMemoryAbstractServiceImpl(StoreManager storeManager, CmisServiceValidator validator) {
        this.fStoreManager = storeManager;
        this.validator = validator;
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
    }

    protected InMemoryAbstractServiceImpl(StoreManager storeManager) {
        this.fStoreManager = storeManager;
        this.validator = storeManager.getServiceValidator();
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, Properties properties, boolean cmis11) {
        if (null == properties) {
            return null;
        }
        String typeId = (String)((PropertyData)properties.getProperties().get("cmis:objectTypeId")).getFirstValue();
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId, cmis11);
        if (typeDefC == null) {
            throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
        }
        return typeDefC.getTypeDefinition();
    }

    protected List<TypeDefinition> getTypeDefinition(String repositoryId, List<String> typeIds, boolean cmis11) {
        if (null == typeIds || typeIds.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>(typeIds.size());
        for (String typeId : typeIds) {
            TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId, cmis11);
            if (typeDefC == null) {
                throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
            }
            result.add(typeDefC.getTypeDefinition());
        }
        return result;
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, StoredObject obj, boolean cmis11) {
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, obj.getTypeId(), cmis11);
        return typeDefC == null ? null : typeDefC.getTypeDefinition();
    }

    protected VersionedDocument getVersionedDocumentOfObjectId(StoredObject so) {
        VersionedDocument verDoc = so instanceof DocumentVersion ? ((DocumentVersion)so).getParentDocument() : (VersionedDocument)so;
        return verDoc;
    }

    protected VersionedDocument testIsNotCheckedOutBySomeoneElse(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        if (verDoc.isCheckedOut()) {
            this.testCheckedOutByCurrentUser(user, verDoc);
        }
        return verDoc;
    }

    protected VersionedDocument testHasProperCheckedOutStatus(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        this.checkHasUser(user);
        this.testIsCheckedOut(verDoc);
        this.testCheckedOutByCurrentUser(user, verDoc);
        return verDoc;
    }

    protected void checkIsVersionableObject(StoredObject so) {
        if (!(so instanceof VersionedDocument) && !(so instanceof DocumentVersion)) {
            throw new CmisInvalidArgumentException("Object is of a versionable type but not instance of VersionedDocument or DocumentVersion.");
        }
    }

    protected void checkHasUser(String user) {
        if (null == user || user.length() == 0) {
            throw new CmisPermissionDeniedException("Object can't be checked-in, no user is given.");
        }
    }

    protected void testCheckedOutByCurrentUser(String user, VersionedDocument verDoc) {
        if (!user.equals(verDoc.getCheckedOutBy())) {
            throw new CmisUpdateConflictException("User " + verDoc.getCheckedOutBy() + " has checked out the document.");
        }
    }

    protected void testIsCheckedOut(VersionedDocument verDoc) {
        if (!verDoc.isCheckedOut()) {
            throw new CmisUpdateConflictException("Document " + verDoc.getId() + " is not checked out.");
        }
    }

    protected boolean isCheckedOut(StoredObject so, String user) {
        if (so instanceof VersionedDocument || so instanceof DocumentVersion) {
            VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
            return verDoc.isCheckedOut() && user.equals(verDoc.getCheckedOutBy());
        }
        return false;
    }
}

