/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.algorithms.regression;

import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.algorithms.regression.CochraneOrcuttModel;
import org.apache.mahout.math.algorithms.regression.LinearRegressorFitter;
import org.apache.mahout.math.algorithms.regression.LinearRegressorFitter$class;
import org.apache.mahout.math.algorithms.regression.LinearRegressorModel;
import org.apache.mahout.math.algorithms.regression.OrdinaryLeastSquares;
import org.apache.mahout.math.algorithms.regression.RegressorFitter$class;
import org.apache.mahout.math.algorithms.regression.RegressorModel;
import org.apache.mahout.math.algorithms.regression.tests.AutocorrelationTests$;
import org.apache.mahout.math.drm.CacheHint$;
import org.apache.mahout.math.drm.CheckpointedDrm;
import org.apache.mahout.math.drm.DrmLike;
import org.apache.mahout.math.drm.RLikeDrmOps$;
import org.apache.mahout.math.drm.package$;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001=\u0011abQ8dQJ\fg.Z(sGV$HO\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011q\u0001C\u0001\u0005[\u0006$\bN\u0003\u0002\n\u0015\u00051Q.\u00195pkRT!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u0001QC\u0001\t\u001e'\r\u0001\u0011c\u0006\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007aI2$D\u0001\u0003\u0013\tQ\"AA\u000bMS:,\u0017M\u001d*fOJ,7o]8s\r&$H/\u001a:\u0011\u0005qiB\u0002\u0001\u0003\u0006=\u0001\u0011\ra\b\u0002\u0002\u0017F\u0011\u0001e\t\t\u0003%\u0005J!AI\n\u0003\u000f9{G\u000f[5oOB\u0011!\u0003J\u0005\u0003KM\u00111!\u00118z\u0011!9\u0003A!A!\u0002\u0013A\u0013a\u00045za\u0016\u0014\b/\u0019:b[\u0016$XM]:\u0011\u0007II3&\u0003\u0002+'\tQAH]3qK\u0006$X\r\u001a \u0011\tIacfI\u0005\u0003[M\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\n0\u0013\t\u00014C\u0001\u0004Ts6\u0014w\u000e\u001c\u0005\u0006e\u0001!\taM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q*\u0004c\u0001\r\u00017!)q%\ra\u0001Q!Iq\u0007\u0001a\u0001\u0002\u0004%\t\u0001O\u0001\ne\u0016<'/Z:t_J,\u0012a\u0006\u0005\nu\u0001\u0001\r\u00111A\u0005\u0002m\nQB]3he\u0016\u001c8o\u001c:`I\u0015\fHC\u0001\u001f@!\t\u0011R(\u0003\u0002?'\t!QK\\5u\u0011\u001d\u0001\u0015(!AA\u0002]\t1\u0001\u001f\u00132\u0011\u0019\u0011\u0005\u0001)Q\u0005/\u0005Q!/Z4sKN\u001cxN\u001d\u0011\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0003)\u0015AC5uKJ\fG/[8ogV\ta\t\u0005\u0002\u0013\u000f&\u0011\u0001j\u0005\u0002\u0004\u0013:$\b\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0001L\u00039IG/\u001a:bi&|gn]0%KF$\"\u0001\u0010'\t\u000f\u0001K\u0015\u0011!a\u0001\r\"1a\n\u0001Q!\n\u0019\u000b1\"\u001b;fe\u0006$\u0018n\u001c8tA!I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!U\u0001\nG\u0006\u001c\u0007.\u001a%j]R,\u0012A\u0015\t\u0003'fs!\u0001V,\u000e\u0003US!A\u0016\u0004\u0002\u0007\u0011\u0014X.\u0003\u0002Y+\u0006I1)Y2iK\"Kg\u000e^\u0005\u00035n\u0013\u0011bQ1dQ\u0016D\u0015N\u001c;\u000b\u0005a+\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u00035\u0019\u0017m\u00195f\u0011&tGo\u0018\u0013fcR\u0011Ah\u0018\u0005\b\u0001r\u000b\t\u00111\u0001S\u0011\u0019\t\u0007\u0001)Q\u0005%\u0006Q1-Y2iK\"Kg\u000e\u001e\u0011\t\u000b\r\u0004A\u0011\u00013\u0002%M,G\u000fS=qKJ\u0004\u0018M]1nKR,'o\u001d\u000b\u0003y\u0015Dqa\n2\u0011\u0002\u0003\u0007a\r\u0005\u0003hU:\u001acB\u0001\ni\u0013\tI7#\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u00141!T1q\u0015\tI7\u0003C\u0003o\u0001\u0011\u0005q.\u0001\u0007dC2\u001cW\u000f\\1uKJCw\u000e\u0006\u0002qgB\u0011!#]\u0005\u0003eN\u0011a\u0001R8vE2,\u0007\"\u0002;n\u0001\u0004)\u0018\u0001C3se>\u0014HI]7\u0011\u0007Q38$\u0003\u0002x+\n9AI]7MS.,\u0007\"B=\u0001\t\u0003Q\u0018a\u00014jiR11P`A\u0001\u0003\u000b\u00012\u0001\u0007?\u001c\u0013\ti(AA\nD_\u000eD'/\u00198f\u001fJ\u001cW\u000f\u001e;N_\u0012,G\u000eC\u0003\u0000q\u0002\u0007Q/A\u0006ee64U-\u0019;ve\u0016\u001c\bBBA\u0002q\u0002\u0007Q/A\u0005ee6$\u0016M]4fi\")q\u0005\u001fa\u0001Q!I\u0011\u0011\u0002\u0001\u0012\u0002\u0013\u0005\u00111B\u0001\u001dg\u0016$\b*\u001f9feB\f'/Y7fi\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiAK\u0002g\u0003\u001fY#!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u0019\u0012AC1o]>$\u0018\r^5p]&!\u0011qDA\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CochraneOrcutt<K>
implements LinearRegressorFitter<K> {
    private LinearRegressorFitter<K> regressor;
    private int iterations;
    private Enumeration.Value cacheHint;
    private boolean calcStandardErrors;
    private boolean calcCommonStatistics;
    private boolean addIntercept;
    private RegressorModel<Object> model;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("regressor");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("iterations");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("cacheHint");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("foo");

    @Override
    public boolean calcStandardErrors() {
        return this.calcStandardErrors;
    }

    @Override
    public void calcStandardErrors_$eq(boolean x$1) {
        this.calcStandardErrors = x$1;
    }

    @Override
    public boolean calcCommonStatistics() {
        return this.calcCommonStatistics;
    }

    @Override
    public void calcCommonStatistics_$eq(boolean x$1) {
        this.calcCommonStatistics = x$1;
    }

    @Override
    public void setStandardHyperparameters(Map<Symbol, Object> hyperparameters) {
        LinearRegressorFitter$class.setStandardHyperparameters(this, hyperparameters);
    }

    @Override
    public <M extends LinearRegressorModel<Object>> M calculateStandardError(DrmLike<K> X, DrmLike<K> drmTarget, Matrix drmXtXinv, M model) {
        return (M)LinearRegressorFitter$class.calculateStandardError(this, X, drmTarget, drmXtXinv, model);
    }

    @Override
    public <M extends LinearRegressorModel<Object>> M calculateCommonStatistics(M model, DrmLike<K> drmTarget, DrmLike<K> residuals) {
        return (M)LinearRegressorFitter$class.calculateCommonStatistics(this, model, drmTarget, residuals);
    }

    @Override
    public <M extends LinearRegressorModel<Object>> M modelPostprocessing(M model, DrmLike<K> X, DrmLike<K> drmTarget, Matrix drmXtXinv) {
        return (M)LinearRegressorFitter$class.modelPostprocessing(this, model, X, drmTarget, drmXtXinv);
    }

    @Override
    public <M extends LinearRegressorModel<Object>> String generateSummaryString(M model) {
        return LinearRegressorFitter$class.generateSummaryString(this, model);
    }

    @Override
    public Map<Symbol, Object> setStandardHyperparameters$default$1() {
        return LinearRegressorFitter$class.setStandardHyperparameters$default$1(this);
    }

    @Override
    public boolean addIntercept() {
        return this.addIntercept;
    }

    @Override
    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    @Override
    public RegressorModel<K> model() {
        return this.model;
    }

    @Override
    public void model_$eq(RegressorModel<K> x$1) {
        this.model = x$1;
    }

    @Override
    public DrmLike<K> fitPredict(DrmLike<K> drmX, DrmLike<K> drmTarget, Seq<Tuple2<Symbol, Object>> hyperparameters) {
        return RegressorFitter$class.fitPredict(this, drmX, drmTarget, hyperparameters);
    }

    public LinearRegressorFitter<K> regressor() {
        return this.regressor;
    }

    public void regressor_$eq(LinearRegressorFitter<K> x$1) {
        this.regressor = x$1;
    }

    public int iterations() {
        return this.iterations;
    }

    public void iterations_$eq(int x$1) {
        this.iterations = x$1;
    }

    public Enumeration.Value cacheHint() {
        return this.cacheHint;
    }

    public void cacheHint_$eq(Enumeration.Value x$1) {
        this.cacheHint = x$1;
    }

    public void setHyperparameters(Map<Symbol, Object> hyperparameters) {
        this.setStandardHyperparameters((Map<Symbol, Object>)hyperparameters.toMap(Predef$.MODULE$.$conforms()));
        this.regressor_$eq((LinearRegressorFitter)hyperparameters.getOrElse((Object)symbol$1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OrdinaryLeastSquares<K> apply() {
                return new OrdinaryLeastSquares<K>();
            }
        }));
        this.regressor().calcStandardErrors_$eq(false);
        this.regressor().calcCommonStatistics_$eq(false);
        this.iterations_$eq(BoxesRunTime.unboxToInt((Object)hyperparameters.getOrElse((Object)symbol$2, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 3;
            }
        })));
        this.cacheHint_$eq((Enumeration.Value)hyperparameters.getOrElse((Object)symbol$3, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply() {
                return CacheHint$.MODULE$.MEMORY_ONLY();
            }
        }));
    }

    public Map<Symbol, Object> setHyperparameters$default$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol$4), (Object)None$.MODULE$)}));
    }

    public double calculateRho(DrmLike<K> errorDrm) {
        Vector error = package$.MODULE$.drm2Checkpointed(errorDrm).collect().viewColumn(0);
        int n = RLikeOps$.MODULE$.v2vOps(error).length() - 1;
        Vector e2 = error.viewPart(1, n);
        Vector e3 = error.viewPart(0, n);
        return RLikeOps$.MODULE$.v2vOps(e3.times(e2)).sum() / RLikeOps$.MODULE$.v2vOps(e3.assign(Functions.SQUARE)).sum();
    }

    @Override
    public CochraneOrcuttModel<K> fit(DrmLike<K> drmFeatures, DrmLike<K> drmTarget, Seq<Tuple2<Symbol, Object>> hyperparameters) {
        this.setHyperparameters((Map<Symbol, Object>)hyperparameters.toMap(Predef$.MODULE$.$conforms()));
        Vector[] betas = new Vector[this.iterations()];
        LinearRegressorModel[] models = new LinearRegressorModel[this.iterations()];
        double[] dws = new double[this.iterations()];
        double[] rhos = new double[this.iterations()];
        int n = package$.MODULE$.safeToNonNegInt(drmTarget.nrow());
        CheckpointedDrm Y = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1)).checkpoint(this.cacheHint());
        CheckpointedDrm Y_lag = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n - 1), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1)).checkpoint(this.cacheHint());
        CheckpointedDrm X = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmFeatures).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), drmFeatures.ncol())).checkpoint(this.cacheHint());
        CheckpointedDrm X_lag = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmFeatures).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n - 1), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), drmFeatures.ncol())).checkpoint(this.cacheHint());
        this.regressor().calcStandardErrors_$eq(true);
        this.regressor().calcCommonStatistics_$eq(true);
        models[0] = this.regressor().fit(drmFeatures, drmTarget, (Seq<Tuple2<Symbol, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.regressor().calcStandardErrors_$eq(false);
        this.regressor().calcCommonStatistics_$eq(false);
        betas[0] = models[0].beta();
        ObjectRef residuals = ObjectRef.create(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).$minus(models[0].predict(drmFeatures)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.iterations()).foreach$mVc$sp((Function1)new Serializable(this, drmFeatures, drmTarget, betas, models, dws, rhos, Y, Y_lag, X, X_lag, residuals){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CochraneOrcutt $outer;
            private final DrmLike drmFeatures$1;
            private final DrmLike drmTarget$1;
            private final Vector[] betas$1;
            private final LinearRegressorModel[] models$1;
            private final double[] dws$1;
            private final double[] rhos$1;
            private final CheckpointedDrm Y$1;
            private final CheckpointedDrm Y_lag$1;
            private final CheckpointedDrm X$1;
            private final CheckpointedDrm X_lag$1;
            private final ObjectRef residuals$1;
            private static Symbol symbol$5;

            static {
                symbol$5 = Symbol$.MODULE$.apply("durbinWatsonTestStatistic");
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double rho_hat;
                this.rhos$1[i - 1] = rho_hat = this.$outer.calculateRho((DrmLike)this.residuals$1.elem);
                DrmLike<K> drmYprime = RLikeDrmOps$.MODULE$.drm2RLikeOps(this.Y$1).$minus(RLikeDrmOps$.MODULE$.drm2RLikeOps(this.Y_lag$1).$times(rho_hat));
                DrmLike<K> drmXprime = RLikeDrmOps$.MODULE$.drm2RLikeOps(this.X$1).$minus(RLikeDrmOps$.MODULE$.drm2RLikeOps(this.X_lag$1).$times(rho_hat));
                if (i == this.$outer.iterations() - 1) {
                    this.$outer.regressor().calcStandardErrors_$eq(true);
                    this.$outer.regressor().calcCommonStatistics_$eq(true);
                }
                this.models$1[i] = this.$outer.regressor().fit(drmXprime, drmYprime, (Seq<Tuple2<Symbol, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.dws$1[i] = BoxesRunTime.unboxToDouble((Object)AutocorrelationTests$.MODULE$.DurbinWatson(this.models$1[i], RLikeDrmOps$.MODULE$.drm2RLikeOps(this.drmTarget$1).$minus(this.models$1[i].predict(this.drmFeatures$1))).testResults().get((Object)symbol$5).get());
                RLikeOps$.MODULE$.v2vOps(this.models$1[i].beta()).update(this.X$1.ncol(), RLikeOps$.MODULE$.v2vOps(this.models$1[i].beta()).apply(this.X$1.ncol()) / (1.0 - rho_hat));
                this.betas$1[i] = this.models$1[i].beta();
                this.residuals$1.elem = RLikeDrmOps$.MODULE$.drm2RLikeOps(this.drmTarget$1).$minus(this.models$1[i].predict(this.drmFeatures$1));
            }
            {
                void var12_12;
                void var11_11;
                void var10_10;
                void var9_9;
                void var8_8;
                void var7_7;
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.drmFeatures$1 = drmFeatures$1;
                this.drmTarget$1 = var3_3;
                this.betas$1 = var4_4;
                this.models$1 = var5_5;
                this.dws$1 = var6_6;
                this.rhos$1 = var7_7;
                this.Y$1 = var8_8;
                this.Y_lag$1 = var9_9;
                this.X$1 = var10_10;
                this.X_lag$1 = var11_11;
                this.residuals$1 = var12_12;
            }
        });
        CochraneOrcuttModel finalModel = new CochraneOrcuttModel(models[this.iterations() - 1]);
        finalModel.betas_$eq(betas);
        finalModel.dws_$eq(dws);
        finalModel.rhos_$eq(rhos);
        finalModel.tScore_$eq(models[this.iterations() - 1].tScore());
        finalModel.pval_$eq(models[this.iterations() - 1].pval());
        finalModel.beta_$eq(models[this.iterations() - 1].beta());
        Vector se = models[this.iterations() - 1].se();
        RLikeOps$.MODULE$.v2vOps(se).update(RLikeOps$.MODULE$.v2vOps(se).length() - 1, RLikeOps$.MODULE$.v2vOps(se).apply(RLikeOps$.MODULE$.v2vOps(se).length() - 1) / (1.0 - rhos[this.iterations() - 2]));
        finalModel.se_$eq(se);
        finalModel.summary_$eq(new StringBuilder().append((Object)"Original Model:\n").append((Object)models[0].summary()).append((Object)"\n\nTransformed Model:\n").append((Object)this.generateSummaryString(finalModel)).append((Object)"\n\nfinal rho: ").append((Object)BoxesRunTime.boxToDouble((double)finalModel.rhos()[this.iterations() - 2])).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nMSE: ", "\\nR2: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)models[this.iterations() - 1].mse()), BoxesRunTime.boxToDouble((double)models[this.iterations() - 1].r2())}))).toString());
        if (models[0].addIntercept()) {
            finalModel.summary_$eq(finalModel.summary().replace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)X.ncol())})), "(Intercept)"));
        }
        return finalModel;
    }

    public CochraneOrcutt(Seq<Tuple2<Symbol, Object>> hyperparameters) {
        RegressorFitter$class.$init$(this);
        LinearRegressorFitter$class.$init$(this);
        this.setHyperparameters((Map<Symbol, Object>)hyperparameters.toMap(Predef$.MODULE$.$conforms()));
    }
}

