/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.internal.tests.IndexPackageAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.util.IOUtils;

public final class OwnCacheKeyMultiReader
extends MultiReader {
    private static final IndexPackageAccess INDEX_PACKAGE_ACCESS = TestSecrets.getIndexPackageAccess();
    private final Set<IndexReader.ClosedListener> readerClosedListeners = new CopyOnWriteArraySet<IndexReader.ClosedListener>();
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = INDEX_PACKAGE_ACCESS.newCacheKey();

        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        public void addClosedListener(IndexReader.ClosedListener listener) {
            OwnCacheKeyMultiReader.this.ensureOpen();
            OwnCacheKeyMultiReader.this.readerClosedListeners.add(listener);
        }
    };

    public OwnCacheKeyMultiReader(IndexReader ... subReaders) throws IOException {
        super(subReaders);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReaderClosedListeners() throws IOException {
        Set<IndexReader.ClosedListener> set = this.readerClosedListeners;
        synchronized (set) {
            IOUtils.applyToAll(this.readerClosedListeners, l -> l.onClose(this.cacheHelper.getKey()));
        }
    }
}

