/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.shaded.com.google.common.base.Objects;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public final class PushDataHandShake
extends RequestMessage {
    public final byte mode;
    public final String shuffleKey;
    public final String partitionUniqueId;
    public final int attemptId;
    public final int numPartitions;
    public final int bufferSize;

    public PushDataHandShake(byte mode, String shuffleKey, String partitionUniqueId, int attemptId, int numSubPartitions, int bufferSize) {
        this.mode = mode;
        this.shuffleKey = shuffleKey;
        this.partitionUniqueId = partitionUniqueId;
        this.attemptId = attemptId;
        this.numPartitions = numSubPartitions;
        this.bufferSize = bufferSize;
    }

    @Override
    public Message.Type type() {
        return Message.Type.PUSH_DATA_HAND_SHAKE;
    }

    @Override
    public int encodedLength() {
        return 1 + Encoders.Strings.encodedLength(this.shuffleKey) + Encoders.Strings.encodedLength(this.partitionUniqueId) + 4 + 4 + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(this.mode);
        Encoders.Strings.encode(buf, this.shuffleKey);
        Encoders.Strings.encode(buf, this.partitionUniqueId);
        buf.writeInt(this.attemptId);
        buf.writeInt(this.numPartitions);
        buf.writeInt(this.bufferSize);
    }

    public static PushDataHandShake decode(ByteBuf buf) {
        byte mode = buf.readByte();
        String shuffleKey = Encoders.Strings.decode(buf);
        String partitionUniqueId = Encoders.Strings.decode(buf);
        int attemptId = buf.readInt();
        int numPartitions = buf.readInt();
        int bufferSize = buf.readInt();
        return new PushDataHandShake(mode, shuffleKey, partitionUniqueId, attemptId, numPartitions, bufferSize);
    }

    public int hashCode() {
        return Objects.hashCode(this.mode, this.shuffleKey, this.partitionUniqueId, this.attemptId, this.numPartitions, this.bufferSize);
    }

    public boolean equals(Object other) {
        if (other instanceof PushDataHandShake) {
            PushDataHandShake o = (PushDataHandShake)other;
            return this.mode == o.mode && this.shuffleKey.equals(o.shuffleKey) && this.partitionUniqueId.equals(o.partitionUniqueId) && this.attemptId == o.attemptId && this.numPartitions == o.numPartitions && this.bufferSize == o.bufferSize && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("mode", this.mode).add("shuffleKey", this.shuffleKey).add("partitionUniqueId", this.partitionUniqueId).add("attemptId", this.attemptId).add("numSubPartitions", this.numPartitions).add("bufferSize", this.bufferSize).toString();
    }
}

