/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import com.alibaba.nacos.common.JustForTest;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictS3Store;
import org.apache.spark.dict.NGlobalDictStore;
import org.apache.spark.dict.NGlobalDictStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGlobalDictionaryV2
implements Serializable {
    public static final String SEPARATOR = "_0_DOT_0_";
    public static final long NO_VERSION_SPECIFIED = -1L;
    protected static final Logger logger = LoggerFactory.getLogger(NGlobalDictionaryV2.class);
    private NGlobalDictMetaInfo metadata;
    private String baseDir;
    private String project;
    private String sourceTable;
    private String sourceColumn;
    private final long buildVersion;
    private boolean isFirst = true;

    public static String toDictBasePath(String workingDir, String project, String table, String column) {
        workingDir = workingDir == null ? "" : workingDir;
        return workingDir + "/" + project + "/dict/global_dict" + "/" + table + "/" + column + "/";
    }

    public NGlobalDictionaryV2(String dictParams, long buildVersion) throws IOException {
        String[] dictInfo = dictParams.split(SEPARATOR);
        this.project = dictInfo[0];
        this.sourceTable = dictInfo[1];
        this.sourceColumn = dictInfo[2];
        this.baseDir = dictInfo[3];
        this.baseDir = NGlobalDictionaryV2.toDictBasePath(this.baseDir, this.project, this.sourceTable, this.sourceColumn);
        this.buildVersion = buildVersion;
        this.metadata = this.getMetaInfo();
        if (this.metadata != null) {
            this.isFirst = false;
        }
    }

    public NGlobalDictionaryV2(String project, String sourceTable, String sourceColumn, String baseDir) throws IOException {
        this(project, sourceTable, sourceColumn, baseDir, -1L);
    }

    public NGlobalDictionaryV2(String project, String sourceTable, String sourceColumn, String baseDir, long buildVersion) throws IOException {
        this.project = project;
        this.sourceTable = sourceTable;
        this.sourceColumn = sourceColumn;
        this.baseDir = NGlobalDictionaryV2.toDictBasePath(baseDir, project, sourceTable, sourceColumn);
        this.buildVersion = buildVersion;
        this.metadata = this.getMetaInfo();
        if (this.metadata != null) {
            this.isFirst = false;
        }
    }

    public String getResourceDir() {
        return NGlobalDictionaryV2.toDictBasePath(null, this.project, this.sourceTable, this.sourceColumn);
    }

    private String getWorkingDir() {
        return this.getResourceStore(this.baseDir).getWorkingDir(this.buildVersion);
    }

    public NBucketDictionary loadBucketDictionary(int bucketId) throws IOException {
        return this.loadBucketDictionary(bucketId, false);
    }

    @JustForTest
    public NBucketDictionary loadBucketDictionaryForTestS3(int bucketId) throws IOException {
        if (null == this.metadata) {
            this.metadata = this.getMetaInfoForTestS3();
        }
        return new NBucketDictionary(this.baseDir, this.getWorkingDir(), bucketId, this.metadata, false, this.buildVersion, true);
    }

    public NBucketDictionary loadBucketDictionary(int bucketId, boolean isForColumnEncoding) throws IOException {
        return this.loadBucketDictionary(bucketId, isForColumnEncoding, this.buildVersion);
    }

    public NBucketDictionary loadBucketDictionary(int bucketId, boolean isForColumnEncoding, long buildVersion) throws IOException {
        if (null == this.metadata) {
            this.metadata = this.getMetaInfo();
        }
        return new NBucketDictionary(this.baseDir, this.getWorkingDir(), bucketId, this.metadata, isForColumnEncoding, buildVersion);
    }

    public NBucketDictionary createNewBucketDictionary() {
        return new NBucketDictionary(this.getWorkingDir());
    }

    public void prepareWrite() throws IOException {
        NGlobalDictStore globalDictStore = this.getResourceStore(this.baseDir);
        globalDictStore.prepareForWrite(this.getWorkingDir());
    }

    @JustForTest
    public void prepareWriteS3() throws IOException {
        NGlobalDictS3Store globalDictStore = new NGlobalDictS3Store(this.baseDir);
        globalDictStore.prepareForWrite(globalDictStore.getWorkingDir(this.buildVersion));
    }

    @JustForTest
    public void writeMetaDictForTestS3(int bucketSize, int maxVersions, long versionTTL) throws IOException {
        NGlobalDictS3Store globalDictStore = new NGlobalDictS3Store(this.baseDir);
        String workingDir = globalDictStore.getWorkingDir(this.buildVersion);
        globalDictStore.writeMetaInfo(bucketSize, workingDir);
        globalDictStore.commit(workingDir, maxVersions, versionTTL, this.buildVersion);
    }

    public void writeMetaDict(int bucketSize, int maxVersions, long versionTTL) throws IOException {
        NGlobalDictStore globalDictStore = this.getResourceStore(this.baseDir);
        globalDictStore.writeMetaInfo(bucketSize, this.getWorkingDir());
        this.commit(maxVersions, versionTTL);
    }

    private NGlobalDictMetaInfo getMetaInfo(NGlobalDictStore globalDictStore) throws IOException {
        NGlobalDictMetaInfo nGlobalDictMetaInfo;
        Long[] versions = globalDictStore.listAllVersions();
        logger.info("getMetaInfo versions.length is {}", (Object)versions.length);
        if (versions.length == 0) {
            return null;
        }
        if (this.buildVersion == -1L || !Arrays.asList(versions).contains(this.buildVersion)) {
            logger.info("Initializes dict metainfo with the latest version:{}", (Object)versions[versions.length - 1]);
            nGlobalDictMetaInfo = globalDictStore.getMetaInfo(versions[versions.length - 1]);
        } else {
            logger.info("Initializes dict metainfo with the specified version:{}", (Object)this.buildVersion);
            nGlobalDictMetaInfo = globalDictStore.getMetaInfo(this.buildVersion);
        }
        logger.info("getMetaInfo metadata is null : [{}]", (Object)(nGlobalDictMetaInfo == null ? 1 : 0));
        return nGlobalDictMetaInfo;
    }

    @JustForTest
    public NGlobalDictMetaInfo getMetaInfoForTestS3() throws IOException {
        NGlobalDictS3Store globalDictStore = new NGlobalDictS3Store(this.baseDir);
        return this.getMetaInfo(globalDictStore);
    }

    public NGlobalDictMetaInfo getMetaInfo() throws IOException {
        NGlobalDictStore globalDictStore = this.getResourceStore(this.baseDir);
        return this.getMetaInfo(globalDictStore);
    }

    public int getBucketSizeOrDefault(int defaultSize) {
        int bucketPartitionSize = this.metadata == null ? defaultSize : this.metadata.getBucketSize();
        return bucketPartitionSize;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    private void commit(int maxVersions, long versionTTL) throws IOException {
        NGlobalDictStore globalDictStore = this.getResourceStore(this.baseDir);
        globalDictStore.commit(this.getWorkingDir(), maxVersions, versionTTL, this.buildVersion);
    }

    private NGlobalDictStore getResourceStore(String baseDir) {
        return NGlobalDictStoreFactory.getResourceStore(baseDir);
    }
}

