/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.model.AbstractJoinRule;
import org.apache.kylin.rec.model.ModelTree;

public class AppendJoinRule
extends AbstractJoinRule {
    @Override
    public boolean isCompatible(NDataModel model, ModelTree modelTree) {
        String factTableName = model.getRootFactTableName();
        if (!StringUtils.equalsIgnoreCase((CharSequence)factTableName, (CharSequence)modelTree.getRootFactTable().getIdentity())) {
            return false;
        }
        for (JoinTableDesc joinTableDesc : model.getJoinTables()) {
            if (!this.detectIncompatible(factTableName, joinTableDesc)) continue;
            return false;
        }
        for (Map.Entry entry : modelTree.getJoins().entrySet()) {
            if (!this.detectIncompatible(factTableName, (JoinTableDesc)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean detectIncompatible(String factTableName, JoinTableDesc joinTable) {
        JoinDesc join = joinTable.getJoin();
        if (join.isNonEquiJoin()) {
            return true;
        }
        return join.isJoinWithFactTable(factTableName) && (joinTable.isToManyJoinRelation() || !join.isLeftJoin());
    }
}

