/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.lang.reflect.AccessibleObject;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.SystemPropertiesCache;

public class Unsafe {
    private Unsafe() {
    }

    public static void systemExit(int status) {
        System.exit(status);
    }

    public static String format(Locale locale, String pattern, Object ... arguments) {
        MessageFormat temp = new MessageFormat(pattern, locale);
        return temp.format(arguments);
    }

    public static void changeAccessibleObject(AccessibleObject accessibleObject, boolean value) {
        accessibleObject.setAccessible(value);
    }

    public static void overwriteSystemProp(Map<String, String> systemProp, String key, String value) {
        if (systemProp != null) {
            systemProp.put(key, System.getProperty(key));
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            SystemPropertiesCache.clearProperty(key);
        } else {
            SystemPropertiesCache.setProperty(key, value);
        }
    }

    public static void restoreAllSystemProp(Map<String, String> systemProp) {
        if (systemProp != null) {
            systemProp.forEach((prop, value) -> SystemPropertiesCache.clearProperty(prop));
            systemProp.clear();
        }
    }

    public static String setProperty(String property, String value) {
        return SystemPropertiesCache.setProperty(property, value);
    }

    public static void clearProperty(String property) {
        SystemPropertiesCache.clearProperty(property);
    }
}

