/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public final class FileUtils {
    public static File findFile(String dir, String ptn) {
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().matches(ptn)) continue;
                return f;
            }
        }
        return null;
    }

    public static List<File> findFiles(String dir, String ptn) {
        File[] files = new File(dir).listFiles();
        if (files != null) {
            return Arrays.stream(files).filter(f -> f.getName().matches(ptn)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public static List<File> findFiles(String dir) {
        Object[] files = new File(dir).listFiles();
        if (files != null) {
            return Lists.newArrayList((Object[])files);
        }
        return Lists.newArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> readFromPropertiesFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Map<String, String> map = FileUtils.readFromPropertiesFile(fileInputStream);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> readFromPropertiesFile(InputStream inputStream) {
        try (BufferedReader confReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            OrderedProperties temp = new OrderedProperties();
            temp.load(confReader);
            Map<String, String> map = temp.getProperties();
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeBase64File(String path) throws Exception {
        File file = new File(path);
        try (FileInputStream inputFile = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            int read = inputFile.read(buffer);
            Preconditions.checkState((read != -1 ? 1 : 0) != 0);
            String string = Base64.encodeBase64String((byte[])buffer);
            return string;
        }
    }

    public static void decoderBase64File(String base64Code, String targetPath) throws Exception {
        byte[] buffer = Base64.decodeBase64((String)base64Code);
        try (FileOutputStream out = new FileOutputStream(targetPath);){
            out.write(buffer);
        }
    }

    public static boolean fileExist(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new RuntimeException("path can not be blank");
        }
        return new File(path).isFile();
    }

    public static boolean folderExist(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new RuntimeException("path can not be blank");
        }
        return new File(path).isDirectory();
    }
}

